package app

import (
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/chat/golibs/gojiplus"
	"code.justin.tv/chat/zuma/app/api"
	"code.justin.tv/chat/zuma/internal/models"
)

func (h *handlers) RemoveMember(ctx context.Context, rw http.ResponseWriter, req *http.Request) {
	var params api.RemoveMemberRequest
	if err := gojiplus.ParseJSONFromRequest(req, &params); err != nil {
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusBadRequest)
		return
	}

	if err := validateRemoveMemberParams(params); err != nil {
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusBadRequest)
		return
	}

	// To remove a member to a group, delete the container view.
	_, err := h.Backend.DeleteContainerView(ctx, params.UserID, models.Entity{params.ContainerEntity})
	if err != nil {
		gojiplus.ServeError(ctx, rw, req, err, http.StatusInternalServerError)
		return
	}

	rw.WriteHeader(http.StatusNoContent)
}

func validateRemoveMemberParams(params api.RemoveMemberRequest) error {
	if params.ContainerEntity.ID() == "" {
		return errx.New("container ID is invalid")
	}

	if params.UserID == "" {
		return errx.New("user ID is invalid")
	}

	return nil
}
