package app

import (
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/chat/golibs/gojiplus"
	"code.justin.tv/chat/zuma/app/api"
	"code.justin.tv/chat/zuma/backend"
	"code.justin.tv/chat/zuma/internal/models"
)

func (h *handlers) UpdateContainer(ctx context.Context, rw http.ResponseWriter, req *http.Request) {
	var params api.UpdateContainerRequest
	if err := gojiplus.ParseJSONFromRequest(req, &params); err != nil {
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusBadRequest)
		return
	}

	if err := validateUpdateContainerParams(params); err != nil {
		gojiplus.ServePublicError(ctx, rw, req, err, http.StatusBadRequest)
		return
	}

	var containerOwner *models.Entity
	if params.ContainerOwner != nil {
		containerOwner = &models.Entity{*params.ContainerOwner}
	}
	var databag *models.Databag
	if params.Databag != nil {
		d := models.Databag(*params.Databag)
		databag = &d
	}
	updateContainerParams := backend.UpdateContainerParams{
		ContainerOwner: containerOwner,
		RequireReview:  params.RequireReview,
		Databag:        databag,
	}
	container, err := h.Backend.UpdateContainer(ctx, models.Entity{params.ContainerEntity}, updateContainerParams)
	if err != nil {
		gojiplus.ServeError(ctx, rw, req, err, http.StatusInternalServerError)
		return
	}

	resp := api.GetContainerResponse{
		Container: exportContainer(container),
	}
	gojiplus.ServeJSON(rw, req, resp)
}

func validateUpdateContainerParams(params api.UpdateContainerRequest) error {
	if params.ContainerEntity.ID() == "" {
		return errx.New("container is invalid")
	}

	return nil
}
