package zuma

import (
	"bytes"
	"encoding/json"

	"golang.org/x/net/context"

	"code.justin.tv/chat/zuma/app/api"
	"code.justin.tv/common/twitchhttp"
)

func (c *client) AddMember(ctx context.Context, params api.AddMemberRequest, reqOpts *twitchhttp.ReqOpts) (api.AddMemberResponse, error) {
	bodyBytes, err := json.Marshal(params)
	if err != nil {
		return api.AddMemberResponse{}, err
	}

	req, err := c.NewRequest("POST", "/v1/maap/members/add", bytes.NewReader(bodyBytes))
	if err != nil {
		return api.AddMemberResponse{}, err
	}

	combinedReqOpts := twitchhttp.MergeReqOpts(reqOpts, twitchhttp.ReqOpts{
		StatName:       "service.zuma.maap.add_member",
		StatSampleRate: defaultStatSampleRate,
	})

	var decoded api.AddMemberResponse
	if _, err := c.DoJSON(ctx, &decoded, req, combinedReqOpts); err != nil {
		return api.AddMemberResponse{}, err
	}
	return decoded, nil
}
