package zuma

import (
	"bytes"
	"encoding/json"

	"golang.org/x/net/context"

	"code.justin.tv/chat/zuma/app/api"
	"code.justin.tv/common/twitchhttp"
)

func (c *client) EditMessage(ctx context.Context, params api.EditMessageRequest, reqOpts *twitchhttp.ReqOpts) (api.EditMessageResponse, error) {
	bodyBytes, err := json.Marshal(params)
	if err != nil {
		return api.EditMessageResponse{}, err
	}

	req, err := c.NewRequest("POST", "/v1/maap/messages/edit", bytes.NewReader(bodyBytes))
	if err != nil {
		return api.EditMessageResponse{}, err
	}

	combinedReqOpts := twitchhttp.MergeReqOpts(reqOpts, twitchhttp.ReqOpts{
		StatName:       "service.zuma.maap.edit_message",
		StatSampleRate: defaultStatSampleRate,
	})

	var decoded api.EditMessageResponse
	if _, err := c.DoJSON(ctx, &decoded, req, combinedReqOpts); err != nil {
		return api.EditMessageResponse{}, err
	}
	return decoded, nil
}
