package zuma

import (
	"bytes"
	"encoding/json"

	"golang.org/x/net/context"

	"code.justin.tv/chat/zuma/app/api"
	"code.justin.tv/common/twitchhttp"
)

func (c *client) ExtractMessage(ctx context.Context, params api.ExtractMessageRequest, reqOpts *twitchhttp.ReqOpts) (api.ExtractMessageResponse, error) {
	bodyBytes, err := json.Marshal(params)
	if err != nil {
		return api.ExtractMessageResponse{}, err
	}

	req, err := c.NewRequest("POST", "/v1/maap/extraction/extract", bytes.NewReader(bodyBytes))
	if err != nil {
		return api.ExtractMessageResponse{}, err
	}

	combinedReqOpts := twitchhttp.MergeReqOpts(reqOpts, twitchhttp.ReqOpts{
		StatName:       "service.zuma.maap_extraction.extract",
		StatSampleRate: defaultStatSampleRate,
	})

	var decoded api.ExtractMessageResponse
	if _, err := c.DoJSON(ctx, &decoded, req, combinedReqOpts); err != nil {
		return api.ExtractMessageResponse{}, err
	}
	return decoded, nil
}
