package zuma

import (
	"bytes"
	"encoding/json"

	"golang.org/x/net/context"

	"code.justin.tv/chat/zuma/app/api"
	"code.justin.tv/common/twitchhttp"
)

func (c *client) GetMember(ctx context.Context, params api.GetMemberRequest, reqOpts *twitchhttp.ReqOpts) (api.GetMemberResponse, error) {
	bodyBytes, err := json.Marshal(params)
	if err != nil {
		return api.GetMemberResponse{}, err
	}

	req, err := c.NewRequest("POST", "/v1/maap/members/get", bytes.NewReader(bodyBytes))
	if err != nil {
		return api.GetMemberResponse{}, err
	}

	combinedReqOpts := twitchhttp.MergeReqOpts(reqOpts, twitchhttp.ReqOpts{
		StatName:       "service.zuma.maap.get_member",
		StatSampleRate: defaultStatSampleRate,
	})

	var decoded api.GetMemberResponse
	if _, err := c.DoJSON(ctx, &decoded, req, combinedReqOpts); err != nil {
		return api.GetMemberResponse{}, err
	}
	return decoded, nil
}
