package zuma

import (
	"bytes"
	"encoding/json"

	"golang.org/x/net/context"

	"code.justin.tv/chat/zuma/app/api"
	"code.justin.tv/common/twitchhttp"
)

func (c *client) ListContainersByOwner(ctx context.Context, params api.ListContainersByOwnerRequest, reqOpts *twitchhttp.ReqOpts) (api.ListContainersByOwnerResponse, error) {
	bodyBytes, err := json.Marshal(params)
	if err != nil {
		return api.ListContainersByOwnerResponse{}, err
	}

	req, err := c.NewRequest("POST", "/v1/maap/containers/list_by_owner", bytes.NewReader(bodyBytes))
	if err != nil {
		return api.ListContainersByOwnerResponse{}, err
	}

	combinedReqOpts := twitchhttp.MergeReqOpts(reqOpts, twitchhttp.ReqOpts{
		StatName:       "service.zuma.maap.list_containers_by_owner",
		StatSampleRate: defaultStatSampleRate,
	})

	var decoded api.ListContainersByOwnerResponse
	if _, err := c.DoJSON(ctx, &decoded, req, combinedReqOpts); err != nil {
		return api.ListContainersByOwnerResponse{}, err
	}
	return decoded, nil
}
