package zuma

import (
	"bytes"
	"encoding/json"

	"golang.org/x/net/context"

	"code.justin.tv/chat/zuma/app/api"
	"code.justin.tv/common/twitchhttp"
)

func (c *client) ListMessages(ctx context.Context, params api.ListMessagesRequest, reqOpts *twitchhttp.ReqOpts) (api.ListMessagesResponse, error) {
	bodyBytes, err := json.Marshal(params)
	if err != nil {
		return api.ListMessagesResponse{}, err
	}

	req, err := c.NewRequest("POST", "/v1/maap/messages/list", bytes.NewReader(bodyBytes))
	if err != nil {
		return api.ListMessagesResponse{}, err
	}

	combinedReqOpts := twitchhttp.MergeReqOpts(reqOpts, twitchhttp.ReqOpts{
		StatName:       "service.zuma.maap.list_messages",
		StatSampleRate: defaultStatSampleRate,
	})

	var decoded api.ListMessagesResponse
	if _, err := c.DoJSON(ctx, &decoded, req, combinedReqOpts); err != nil {
		return api.ListMessagesResponse{}, err
	}
	return decoded, nil
}
