package zuma

import (
	"bytes"
	"encoding/json"

	"golang.org/x/net/context"

	"code.justin.tv/chat/zuma/app/api"
	"code.justin.tv/common/twitchhttp"
)

func (c *client) UpdateContainer(ctx context.Context, params api.UpdateContainerRequest, reqOpts *twitchhttp.ReqOpts) (api.UpdateContainerResponse, error) {
	bodyBytes, err := json.Marshal(params)
	if err != nil {
		return api.UpdateContainerResponse{}, err
	}

	req, err := c.NewRequest("POST", "/v1/maap/containers/update", bytes.NewReader(bodyBytes))
	if err != nil {
		return api.UpdateContainerResponse{}, err
	}

	combinedReqOpts := twitchhttp.MergeReqOpts(reqOpts, twitchhttp.ReqOpts{
		StatName:       "service.zuma.maap.update_container",
		StatSampleRate: defaultStatSampleRate,
	})

	var decoded api.UpdateContainerResponse
	if _, err := c.DoJSON(ctx, &decoded, req, combinedReqOpts); err != nil {
		return api.UpdateContainerResponse{}, err
	}
	return decoded, nil
}
