package zuma

import api "code.justin.tv/chat/zuma/app/api"
import context "golang.org/x/net/context"
import mock "github.com/stretchr/testify/mock"
import twitchhttp "code.justin.tv/common/twitchhttp"

// @generated

// MockClient is an autogenerated mock type for the Client type
type MockClient struct {
	mock.Mock
}

// AddCommunityBan provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) AddCommunityBan(ctx context.Context, params api.AddCommunityBanRequest, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, api.AddCommunityBanRequest, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// AddCommunityMod provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) AddCommunityMod(ctx context.Context, params api.AddCommunityModRequest, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, api.AddCommunityModRequest, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// AddCommunityTimeout provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) AddCommunityTimeout(ctx context.Context, params api.AddCommunityTimeoutRequest, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, api.AddCommunityTimeoutRequest, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// AddMember provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) AddMember(ctx context.Context, params api.AddMemberRequest, reqOpts *twitchhttp.ReqOpts) (api.AddMemberResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.AddMemberResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.AddMemberRequest, *twitchhttp.ReqOpts) api.AddMemberResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.AddMemberResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.AddMemberRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// AddMod provides a mock function with given fields: ctx, channelID, targetUserID, requestingUserID, reqOpts
func (_m *MockClient) AddMod(ctx context.Context, channelID string, targetUserID string, requestingUserID string, reqOpts *twitchhttp.ReqOpts) (bool, error) {
	ret := _m.Called(ctx, channelID, targetUserID, requestingUserID, reqOpts)

	var r0 bool
	if rf, ok := ret.Get(0).(func(context.Context, string, string, string, *twitchhttp.ReqOpts) bool); ok {
		r0 = rf(ctx, channelID, targetUserID, requestingUserID, reqOpts)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string, string, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, channelID, targetUserID, requestingUserID, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// AddUserBlock provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) AddUserBlock(ctx context.Context, params api.AddUserBlockParams, reqOpts *twitchhttp.ReqOpts) (api.AddUserBlockResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.AddUserBlockResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.AddUserBlockParams, *twitchhttp.ReqOpts) api.AddUserBlockResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.AddUserBlockResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.AddUserBlockParams, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// AddUserFollowedCommunity provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) AddUserFollowedCommunity(ctx context.Context, params api.AddUserFollowedCommunityRequest, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, api.AddUserFollowedCommunityRequest, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ApproveMessage provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) ApproveMessage(ctx context.Context, params api.ApproveMessageRequest, reqOpts *twitchhttp.ReqOpts) (api.ApproveMessageResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.ApproveMessageResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.ApproveMessageRequest, *twitchhttp.ReqOpts) api.ApproveMessageResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.ApproveMessageResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.ApproveMessageRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CheckEmoticonsAccess provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) CheckEmoticonsAccess(ctx context.Context, params api.CheckEmoticonsAccessRequest, reqOpts *twitchhttp.ReqOpts) (api.CheckEmoticonsAccessResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.CheckEmoticonsAccessResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.CheckEmoticonsAccessRequest, *twitchhttp.ReqOpts) api.CheckEmoticonsAccessResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.CheckEmoticonsAccessResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.CheckEmoticonsAccessRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CountCommunityFollowers provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) CountCommunityFollowers(ctx context.Context, params api.CountCommunityFollowersRequest, reqOpts *twitchhttp.ReqOpts) (api.CountCommunityFollowersResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.CountCommunityFollowersResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.CountCommunityFollowersRequest, *twitchhttp.ReqOpts) api.CountCommunityFollowersResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.CountCommunityFollowersResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.CountCommunityFollowersRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateCommunity provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) CreateCommunity(ctx context.Context, params api.CreateCommunityRequest, reqOpts *twitchhttp.ReqOpts) (api.CreateCommunityResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.CreateCommunityResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.CreateCommunityRequest, *twitchhttp.ReqOpts) api.CreateCommunityResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.CreateCommunityResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.CreateCommunityRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateContainer provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) CreateContainer(ctx context.Context, params api.CreateContainerRequest, reqOpts *twitchhttp.ReqOpts) (api.CreateContainerResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.CreateContainerResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.CreateContainerRequest, *twitchhttp.ReqOpts) api.CreateContainerResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.CreateContainerResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.CreateContainerRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateMessage provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) CreateMessage(ctx context.Context, params api.CreateMessageRequest, reqOpts *twitchhttp.ReqOpts) (api.CreateMessageResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.CreateMessageResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.CreateMessageRequest, *twitchhttp.ReqOpts) api.CreateMessageResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.CreateMessageResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.CreateMessageRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DeleteMessage provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) DeleteMessage(ctx context.Context, params api.DeleteMessageRequest, reqOpts *twitchhttp.ReqOpts) (api.DeleteMessageResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.DeleteMessageResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.DeleteMessageRequest, *twitchhttp.ReqOpts) api.DeleteMessageResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.DeleteMessageResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.DeleteMessageRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// EditMessage provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) EditMessage(ctx context.Context, params api.EditMessageRequest, reqOpts *twitchhttp.ReqOpts) (api.EditMessageResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.EditMessageResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.EditMessageRequest, *twitchhttp.ReqOpts) api.EditMessageResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.EditMessageResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.EditMessageRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ExtractMessage provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) ExtractMessage(ctx context.Context, params api.ExtractMessageRequest, reqOpts *twitchhttp.ReqOpts) (api.ExtractMessageResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.ExtractMessageResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.ExtractMessageRequest, *twitchhttp.ReqOpts) api.ExtractMessageResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.ExtractMessageResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.ExtractMessageRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetChannelCommunity provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) GetChannelCommunity(ctx context.Context, params api.GetChannelCommunityRequest, reqOpts *twitchhttp.ReqOpts) (api.GetChannelCommunityResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.GetChannelCommunityResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.GetChannelCommunityRequest, *twitchhttp.ReqOpts) api.GetChannelCommunityResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.GetChannelCommunityResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.GetChannelCommunityRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetCommunityBan provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) GetCommunityBan(ctx context.Context, params api.GetCommunityBanRequest, reqOpts *twitchhttp.ReqOpts) (api.GetCommunityBanResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.GetCommunityBanResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.GetCommunityBanRequest, *twitchhttp.ReqOpts) api.GetCommunityBanResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.GetCommunityBanResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.GetCommunityBanRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetCommunityFollower provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) GetCommunityFollower(ctx context.Context, params api.GetCommunityFollowerRequest, reqOpts *twitchhttp.ReqOpts) (api.GetCommunityFollowerResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.GetCommunityFollowerResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.GetCommunityFollowerRequest, *twitchhttp.ReqOpts) api.GetCommunityFollowerResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.GetCommunityFollowerResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.GetCommunityFollowerRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetCommunityIDByName provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) GetCommunityIDByName(ctx context.Context, params api.GetCommunityByNameRequest, reqOpts *twitchhttp.ReqOpts) (api.GetCommunityByNameResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.GetCommunityByNameResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.GetCommunityByNameRequest, *twitchhttp.ReqOpts) api.GetCommunityByNameResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.GetCommunityByNameResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.GetCommunityByNameRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetCommunityMod provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) GetCommunityMod(ctx context.Context, params api.GetCommunityModRequest, reqOpts *twitchhttp.ReqOpts) (api.GetCommunityModResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.GetCommunityModResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.GetCommunityModRequest, *twitchhttp.ReqOpts) api.GetCommunityModResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.GetCommunityModResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.GetCommunityModRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetCommunityModerationLogs provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) GetCommunityModerationLogs(ctx context.Context, params api.GetCommunityModerationActionsRequest, reqOpts *twitchhttp.ReqOpts) (api.GetCommunityModerationActionsResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.GetCommunityModerationActionsResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.GetCommunityModerationActionsRequest, *twitchhttp.ReqOpts) api.GetCommunityModerationActionsResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.GetCommunityModerationActionsResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.GetCommunityModerationActionsRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetCommunityPermissions provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) GetCommunityPermissions(ctx context.Context, params api.GetCommunityPermissionsRequest, reqOpts *twitchhttp.ReqOpts) (api.GetCommunityPermissionsResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.GetCommunityPermissionsResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.GetCommunityPermissionsRequest, *twitchhttp.ReqOpts) api.GetCommunityPermissionsResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.GetCommunityPermissionsResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.GetCommunityPermissionsRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetCommunitySettings provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) GetCommunitySettings(ctx context.Context, params api.GetCommunitySettingsRequest, reqOpts *twitchhttp.ReqOpts) (api.GetCommunitySettingsResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.GetCommunitySettingsResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.GetCommunitySettingsRequest, *twitchhttp.ReqOpts) api.GetCommunitySettingsResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.GetCommunitySettingsResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.GetCommunitySettingsRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetCommunityTimeout provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) GetCommunityTimeout(ctx context.Context, params api.GetCommunityTimeoutRequest, reqOpts *twitchhttp.ReqOpts) (api.GetCommunityTimeoutResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.GetCommunityTimeoutResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.GetCommunityTimeoutRequest, *twitchhttp.ReqOpts) api.GetCommunityTimeoutResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.GetCommunityTimeoutResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.GetCommunityTimeoutRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetContainer provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) GetContainer(ctx context.Context, params api.GetContainerRequest, reqOpts *twitchhttp.ReqOpts) (api.GetContainerResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.GetContainerResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.GetContainerRequest, *twitchhttp.ReqOpts) api.GetContainerResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.GetContainerResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.GetContainerRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetContainerView provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) GetContainerView(ctx context.Context, params api.GetContainerViewRequest, reqOpts *twitchhttp.ReqOpts) (api.GetContainerViewResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.GetContainerViewResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.GetContainerViewRequest, *twitchhttp.ReqOpts) api.GetContainerViewResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.GetContainerViewResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.GetContainerViewRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMember provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) GetMember(ctx context.Context, params api.GetMemberRequest, reqOpts *twitchhttp.ReqOpts) (api.GetMemberResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.GetMemberResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.GetMemberRequest, *twitchhttp.ReqOpts) api.GetMemberResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.GetMemberResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.GetMemberRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMessage provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) GetMessage(ctx context.Context, params api.GetMessageRequest, reqOpts *twitchhttp.ReqOpts) (api.GetMessageResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.GetMessageResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.GetMessageRequest, *twitchhttp.ReqOpts) api.GetMessageResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.GetMessageResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.GetMessageRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMod provides a mock function with given fields: ctx, channelID, userID, reqOpts
func (_m *MockClient) GetMod(ctx context.Context, channelID string, userID string, reqOpts *twitchhttp.ReqOpts) (api.GetModResponse, error) {
	ret := _m.Called(ctx, channelID, userID, reqOpts)

	var r0 api.GetModResponse
	if rf, ok := ret.Get(0).(func(context.Context, string, string, *twitchhttp.ReqOpts) api.GetModResponse); ok {
		r0 = rf(ctx, channelID, userID, reqOpts)
	} else {
		r0 = ret.Get(0).(api.GetModResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, channelID, userID, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// InternalGetCommunitySettings provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) InternalGetCommunitySettings(ctx context.Context, params api.GetCommunitySettingsRequest, reqOpts *twitchhttp.ReqOpts) (api.GetCommunitySettingsResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.GetCommunitySettingsResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.GetCommunitySettingsRequest, *twitchhttp.ReqOpts) api.GetCommunitySettingsResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.GetCommunitySettingsResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.GetCommunitySettingsRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListCommunityBans provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) ListCommunityBans(ctx context.Context, params api.ListCommunityBansRequest, reqOpts *twitchhttp.ReqOpts) (api.ListCommunityBansResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.ListCommunityBansResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.ListCommunityBansRequest, *twitchhttp.ReqOpts) api.ListCommunityBansResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.ListCommunityBansResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.ListCommunityBansRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListCommunityFollowers provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) ListCommunityFollowers(ctx context.Context, params api.ListCommunityFollowersRequest, reqOpts *twitchhttp.ReqOpts) (api.ListCommunityFollowersResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.ListCommunityFollowersResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.ListCommunityFollowersRequest, *twitchhttp.ReqOpts) api.ListCommunityFollowersResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.ListCommunityFollowersResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.ListCommunityFollowersRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListCommunityMods provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) ListCommunityMods(ctx context.Context, params api.ListCommunityModsRequest, reqOpts *twitchhttp.ReqOpts) (api.ListCommunityModsResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.ListCommunityModsResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.ListCommunityModsRequest, *twitchhttp.ReqOpts) api.ListCommunityModsResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.ListCommunityModsResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.ListCommunityModsRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListCommunityTimeouts provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) ListCommunityTimeouts(ctx context.Context, params api.ListCommunityTimeoutsRequest, reqOpts *twitchhttp.ReqOpts) (api.ListCommunityTimeoutsResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.ListCommunityTimeoutsResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.ListCommunityTimeoutsRequest, *twitchhttp.ReqOpts) api.ListCommunityTimeoutsResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.ListCommunityTimeoutsResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.ListCommunityTimeoutsRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListContainerViewsByUser provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) ListContainerViewsByUser(ctx context.Context, params api.ListContainerViewsByUserRequest, reqOpts *twitchhttp.ReqOpts) (api.ListContainerViewsByUserResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.ListContainerViewsByUserResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.ListContainerViewsByUserRequest, *twitchhttp.ReqOpts) api.ListContainerViewsByUserResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.ListContainerViewsByUserResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.ListContainerViewsByUserRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListContainersByOwner provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) ListContainersByOwner(ctx context.Context, params api.ListContainersByOwnerRequest, reqOpts *twitchhttp.ReqOpts) (api.ListContainersByOwnerResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.ListContainersByOwnerResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.ListContainersByOwnerRequest, *twitchhttp.ReqOpts) api.ListContainersByOwnerResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.ListContainersByOwnerResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.ListContainersByOwnerRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListMessages provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) ListMessages(ctx context.Context, params api.ListMessagesRequest, reqOpts *twitchhttp.ReqOpts) (api.ListMessagesResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.ListMessagesResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.ListMessagesRequest, *twitchhttp.ReqOpts) api.ListMessagesResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.ListMessagesResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.ListMessagesRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListMods provides a mock function with given fields: ctx, channelID, reqOpts
func (_m *MockClient) ListMods(ctx context.Context, channelID string, reqOpts *twitchhttp.ReqOpts) (api.ListModsResponse, error) {
	ret := _m.Called(ctx, channelID, reqOpts)

	var r0 api.ListModsResponse
	if rf, ok := ret.Get(0).(func(context.Context, string, *twitchhttp.ReqOpts) api.ListModsResponse); ok {
		r0 = rf(ctx, channelID, reqOpts)
	} else {
		r0 = ret.Get(0).(api.ListModsResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, channelID, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListUserBlocks provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) ListUserBlocks(ctx context.Context, params api.ListUserBlocksParams, reqOpts *twitchhttp.ReqOpts) (api.ListUserBlocksResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.ListUserBlocksResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.ListUserBlocksParams, *twitchhttp.ReqOpts) api.ListUserBlocksResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.ListUserBlocksResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.ListUserBlocksParams, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListUserFollowedCommunities provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) ListUserFollowedCommunities(ctx context.Context, params api.ListUserFollowedCommunitiesRequest, reqOpts *twitchhttp.ReqOpts) (api.ListUserFollowedCommunitiesResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.ListUserFollowedCommunitiesResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.ListUserFollowedCommunitiesRequest, *twitchhttp.ReqOpts) api.ListUserFollowedCommunitiesResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.ListUserFollowedCommunitiesResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.ListUserFollowedCommunitiesRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ParseMessage provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) ParseMessage(ctx context.Context, params api.ParseMessageRequest, reqOpts *twitchhttp.ReqOpts) (api.ParseMessageResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.ParseMessageResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.ParseMessageRequest, *twitchhttp.ReqOpts) api.ParseMessageResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.ParseMessageResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.ParseMessageRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// RejectMessage provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) RejectMessage(ctx context.Context, params api.RejectMessageRequest, reqOpts *twitchhttp.ReqOpts) (api.RejectMessageResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.RejectMessageResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.RejectMessageRequest, *twitchhttp.ReqOpts) api.RejectMessageResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.RejectMessageResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.RejectMessageRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// RemoveCommunityBan provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) RemoveCommunityBan(ctx context.Context, params api.RemoveCommunityBanRequest, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, api.RemoveCommunityBanRequest, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// RemoveCommunityImage provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) RemoveCommunityImage(ctx context.Context, params api.RemoveCommunityImageRequest, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, api.RemoveCommunityImageRequest, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// RemoveCommunityMod provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) RemoveCommunityMod(ctx context.Context, params api.RemoveCommunityModRequest, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, api.RemoveCommunityModRequest, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// RemoveCommunityTimeout provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) RemoveCommunityTimeout(ctx context.Context, params api.RemoveCommunityTimeoutRequest, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, api.RemoveCommunityTimeoutRequest, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// RemoveMember provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) RemoveMember(ctx context.Context, params api.RemoveMemberRequest, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, api.RemoveMemberRequest, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// RemoveMod provides a mock function with given fields: ctx, channelID, targetUserID, requestingUserID, reqOpts
func (_m *MockClient) RemoveMod(ctx context.Context, channelID string, targetUserID string, requestingUserID string, reqOpts *twitchhttp.ReqOpts) (bool, error) {
	ret := _m.Called(ctx, channelID, targetUserID, requestingUserID, reqOpts)

	var r0 bool
	if rf, ok := ret.Get(0).(func(context.Context, string, string, string, *twitchhttp.ReqOpts) bool); ok {
		r0 = rf(ctx, channelID, targetUserID, requestingUserID, reqOpts)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string, string, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, channelID, targetUserID, requestingUserID, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// RemoveUserBlock provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) RemoveUserBlock(ctx context.Context, params api.RemoveUserBlockParams, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, api.RemoveUserBlockParams, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// RemoveUserFollowedCommunity provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) RemoveUserFollowedCommunity(ctx context.Context, params api.RemoveUserFollowedCommunityRequest, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, api.RemoveUserFollowedCommunityRequest, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ReportChannelCommunity provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) ReportChannelCommunity(ctx context.Context, params api.ReportChannelCommunityRequest, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, api.ReportChannelCommunityRequest, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ReportCommunity provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) ReportCommunity(ctx context.Context, params api.ReportCommunityRequest, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, api.ReportCommunityRequest, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SetChannelCommunities provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) SetChannelCommunities(ctx context.Context, params api.SetChannelCommunitiesRequest, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, api.SetChannelCommunitiesRequest, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SetChannelCommunity provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) SetChannelCommunity(ctx context.Context, params api.SetChannelCommunityRequest, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, api.SetChannelCommunityRequest, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SetCommunitySettings provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) SetCommunitySettings(ctx context.Context, params api.SetCommunitySettingsRequest, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, api.SetCommunitySettingsRequest, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// TOSBanCommunity provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) TOSBanCommunity(ctx context.Context, params api.TOSBanCommunityRequest, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, api.TOSBanCommunityRequest, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// TopCommunities provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) TopCommunities(ctx context.Context, params api.TopCommunitiesRequest, reqOpts *twitchhttp.ReqOpts) (api.TopCommunitiesResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.TopCommunitiesResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.TopCommunitiesRequest, *twitchhttp.ReqOpts) api.TopCommunitiesResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.TopCommunitiesResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.TopCommunitiesRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// TopUserFollowedCommunities provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) TopUserFollowedCommunities(ctx context.Context, params api.TopUserFollowedCommunitiesRequest, reqOpts *twitchhttp.ReqOpts) (api.TopUserFollowedCommunitiesResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.TopUserFollowedCommunitiesResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.TopUserFollowedCommunitiesRequest, *twitchhttp.ReqOpts) api.TopUserFollowedCommunitiesResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.TopUserFollowedCommunitiesResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.TopUserFollowedCommunitiesRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UnsetChannelCommunity provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) UnsetChannelCommunity(ctx context.Context, params api.UnsetChannelCommunityRequest, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, api.UnsetChannelCommunityRequest, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UpdateContainer provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) UpdateContainer(ctx context.Context, params api.UpdateContainerRequest, reqOpts *twitchhttp.ReqOpts) (api.UpdateContainerResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.UpdateContainerResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.UpdateContainerRequest, *twitchhttp.ReqOpts) api.UpdateContainerResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.UpdateContainerResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.UpdateContainerRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateContainerView provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) UpdateContainerView(ctx context.Context, params api.UpdateContainerViewRequest, reqOpts *twitchhttp.ReqOpts) (api.UpdateContainerViewResponse, error) {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 api.UpdateContainerViewResponse
	if rf, ok := ret.Get(0).(func(context.Context, api.UpdateContainerViewRequest, *twitchhttp.ReqOpts) api.UpdateContainerViewResponse); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Get(0).(api.UpdateContainerViewResponse)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, api.UpdateContainerViewRequest, *twitchhttp.ReqOpts) error); ok {
		r1 = rf(ctx, params, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UploadCommunityImage provides a mock function with given fields: ctx, params, reqOpts
func (_m *MockClient) UploadCommunityImage(ctx context.Context, params api.UploadCommunityImageRequest, reqOpts *twitchhttp.ReqOpts) error {
	ret := _m.Called(ctx, params, reqOpts)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, api.UploadCommunityImageRequest, *twitchhttp.ReqOpts) error); ok {
		r0 = rf(ctx, params, reqOpts)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

var _ Client = (*MockClient)(nil)
