package twitchhttp

import (
	"bytes"
	"io/ioutil"
	"net/http"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

func TestHandleFailedResponse(t *testing.T) {
	Convey("Handles Failed Responses", t, func() {
		resp := &http.Response{StatusCode: http.StatusInternalServerError}

		Convey("Response is json", func() {
			resp.Body = ioutil.NopCloser(bytes.NewBufferString("{ \"Message\": \"Hello\" }"))
			err := *HandleFailedResponse(resp)
			So(err.StatusCode, ShouldEqual, http.StatusInternalServerError)
			So(err.Message, ShouldEqual, "Hello")
		})
		Convey("Response is html", func() {
			resp.Body = ioutil.NopCloser(bytes.NewBufferString("<html />"))
			err := *HandleFailedResponse(resp)
			So(err.StatusCode, ShouldEqual, http.StatusInternalServerError)
			So(err.Message, ShouldEqual, "Unable to read response body: invalid character '<' looking for beginning of value")
		})
	})
}
