package twitchhttp

import (
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

func TestMergeReqOpts(t *testing.T) {
	Convey("MergeReqOpts", t, func() {
		defaults := ReqOpts{
			StatName:       "default_stat_name",
			StatSampleRate: 0.1,
		}
		Convey("if input has parameters", func() {
			input := ReqOpts{
				AuthorizationToken: "thisisatoken",
				StatName:           "input_stat_name",
				StatSampleRate:     0.5,
			}
			merged := MergeReqOpts(&input, defaults)
			if merged.AuthorizationToken != "thisisatoken" {
				t.Fail()
			}
			if merged.StatName != "input_stat_name" {
				t.Fail()
			}
			if merged.StatSampleRate != 0.5 {
				t.Fail()
			}
		})
		Convey("if input is zero values", func() {
			input := &ReqOpts{}
			merged := MergeReqOpts(input, defaults)
			if merged.StatName != "default_stat_name" {
				t.Fail()
			}
			if merged.StatSampleRate != 0.1 {
				t.Fail()
			}
			if merged.AuthorizationToken != "" {
				t.Fail()
			}
		})
	})
}
