package yimg_test

import (
	"testing"

	"code.justin.tv/common/yimg"
)

var channelOfflineImageInput = []byte("--- \n:sizes: \n- 640x360\n:ratio: 1.7777777777777777\n:uid: 43c2de9e52bd3bf3\n:format: png\n")
var channelOfflineImageUser = "avalonstar"
var channelOfflineImageOutput = "https://static-cdn.jtvnw.net/jtv_user_pictures/avalonstar-channel_offline_image-43c2de9e52bd3bf3-640x360.png"

func TestChannelOfflineImages(t *testing.T) {
	got, err := yimg.ChannelOfflineImages(channelOfflineImageInput, channelOfflineImageUser)
	if err != nil {
		t.Errorf("err=%v", err)
	}
	if got["640x360"].URL != channelOfflineImageOutput {
		t.Errorf("have=%v;want=%v", got["640x360"].URL, channelOfflineImageOutput)
	}
}
