package yimg_test

import (
	"testing"

	"code.justin.tv/common/yimg"
)

var profileBannerInput = []byte("--- \n:heights: \n- 480\n:uid: 43c2de9e52bd3bf3\n:format: jpeg\n")
var profileBannerUser = "avalonstar"
var profileBannerOutput = "https://static-cdn.jtvnw.net/jtv_user_pictures/avalonstar-profile_banner-43c2de9e52bd3bf3-480.jpeg"

func TestProfileBanners(t *testing.T) {
	got, err := yimg.ProfileBanners(profileBannerInput, profileBannerUser)
	if err != nil {
		t.Errorf("err=%v", err)
	}
	if got["480"].URL != profileBannerOutput {
		t.Errorf("have=%v;want=%v", got["480"].URL, profileBannerOutput)
	}
}
