package yimg_test

import (
	"testing"

	"code.justin.tv/common/yimg"
)

var profileImageInput = []byte("--- \n:sizes: \n- 600x600\n- 300x300\n- 150x150\n- 70x70\n- 50x50\n- 28x28\n:ratio: 1.0\n:uid: 43c2de9e52bd3bf3\n:format: jpeg\n")
var profileImageUser = "avalonstar"
var profileImageOutput = "https://static-cdn.jtvnw.net/jtv_user_pictures/avalonstar-profile_image-43c2de9e52bd3bf3-300x300.jpeg"

func TestProfileImages(t *testing.T) {
	got, err := yimg.ProfileImages(profileImageInput, profileImageUser)
	if err != nil {
		t.Errorf("err=%v", err)
	}
	if got["300x300"].URL != profileImageOutput {
		t.Errorf("have=%v;want=%v", got["300x300"].URL, profileImageOutput)
	}
}
