package nuclear_waste_test

import (
	"context"
	"testing"

	"code.justin.tv/edge/client-incubator/nuclear_waste"
	"code.justin.tv/foundation/twitchclient"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestNuclearWasteIntegration(t *testing.T) {
	conf := twitchclient.ClientConf{Host: "https://api.internal.twitch.tv"}
	cl, err := nuclear_waste.NewClient(conf)
	require.NoError(t, err)

	ctx := context.Background()
	userID := "135031865" // tonyghita

	t.Run("UserEmotes", func(t *testing.T) {
		collection, err := cl.UserEmotes(ctx, userID, nil)
		require.NoError(t, err)
		assert.NotEmpty(t, collection)
	})

	t.Run("GetPremiumStatuses", func(t *testing.T) {
		statuses, err := cl.GetPremiumStatuses(ctx, userID, nil)
		require.NoError(t, err)

		assert.True(t, statuses.HasPrime)
		assert.True(t, statuses.HasTurbo)
	})

	t.Run("Subscription", func(t *testing.T) {
		channelID := "30976847" // pondelinp
		sub, err := cl.Subscription(ctx, userID, channelID, nil)
		require.NoError(t, err)
		assert.NotNil(t, sub)
	})

	t.Run("ActivateSDKLicense", func(t *testing.T) {
		channelID := "30976847"                       // pondelinp
		clientID := "jzkbprff40iqj646a697cyrvl0zt2m6" // Visage
		game := "Overwatch"
		err := cl.ActivateSDKLicense(ctx, clientID, channelID, &game, nil)
		require.NoError(t, err)
	})

	t.Run("ChannelFeed", func(t *testing.T) {
		channelID := "30976847" // pondelinp
		err := cl.ChannelFeed(ctx, channelID, false, nil)
		require.NoError(t, err)
	})
}
