package twitchdoer

import (
	"io"
	"net/http"

	"code.justin.tv/foundation/twitchclient"
	"golang.org/x/net/context"
)

// TwitchHTTPDoer does a Do(request) call using twitch HTTP client
type TwitchHTTPDoer struct {
	Client twitchclient.Client
	Reqopt twitchclient.ReqOpts
}

// Do a http request using the twitch client
func (t *TwitchHTTPDoer) Do(req *http.Request) (*http.Response, error) {
	return t.Client.Do(req.Context(), req, t.Reqopt)
}

// NewTwitchRequest implements NewHTTPRequest for twitchhttp.Client
func (t *TwitchHTTPDoer) NewTwitchRequest(ctx context.Context, method string, url string, body io.Reader) (*http.Request, error) {
	req, err := t.Client.NewRequest(method, url, body)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	return req, nil
}
