package distconf

import (
	"os"
	"strings"
)

type CommandLine struct {
	Prefix string
	Source []string
}

func (p *CommandLine) source() []string {
	if p.Source == nil {
		return os.Args
	}
	return p.Source
}

func (p *CommandLine) Get(key string) ([]byte, error) {
	argPrefix := p.Prefix + key + "="
	for _, arg := range p.source() {
		if !strings.HasPrefix(arg, argPrefix) {
			continue
		}
		argSuffix := arg[len(argPrefix):]
		return []byte(argSuffix), nil
	}
	return nil, nil
}

func (p *CommandLine) Close() {
}