package verb

import (
	"encoding/json"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

func TestVerb_Equality(t *testing.T) {
	Convey("Verb Equality", t, func() {
		Convey("Create", func() {
			verb := Verb("create")
			So(verb, ShouldEqual, Create)
			So(verb, ShouldNotEqual, Update)
		})
		Convey("Update", func() {
			verb := Verb("update")
			So(verb, ShouldEqual, Update)
			So(verb, ShouldNotEqual, Delete)
		})
		Convey("Delete", func() {
			verb := Verb("delete")
			So(verb, ShouldEqual, Delete)
			So(verb, ShouldNotEqual, Create)
		})
	})
}

func TestVerb_Parse(t *testing.T) {
	Convey("Verb Parsing", t, func() {
		Convey("Parse create", func() {
			verb, err := FromString("create")
			So(err, ShouldBeNil)
			So(verb, ShouldEqual, Create)
		})
		Convey("Parse empty string", func() {
			_, err := FromString("")
			So(err, ShouldNotBeNil)
		})
	})
}

func TestVerb_JSON(t *testing.T) {
	type Holder struct {
		Verb *Verb `json:"verb"`
	}
	Convey("Verb JSON Marshall/Unmarshall", t, func() {
		Convey("With normal verb", func() {
			verb := Create
			a := Holder{Verb: &verb}

			bytes, err := json.Marshal(a)
			So(err, ShouldBeNil)
			So(bytes, ShouldNotBeNil)

			b := Holder{}
			So(b, ShouldNotResemble, a)
			err = json.Unmarshal(bytes, &b)
			So(err, ShouldBeNil)
			So(b, ShouldResemble, a)
		})

		Convey("Testing backwards compatibility", func() {
			bytes := []byte("{\"verb\": \"create\"}")

			holder := Holder{}
			err := json.Unmarshal(bytes, &holder)
			So(err, ShouldBeNil)
			So(*holder.Verb, ShouldEqual, Create)
		})
	})
}
