# Connections Service
Manage twitch user connections to third party platforms and apps.

Initially proposed as the backend for this page:
![](doc/img/connections.png)

# Endpoints
###Environments
production = [https://connections.internal.twitch.tv/](https://connections.internal.twitch.tv/)

staging = [https://connections-staging.internal.twitch.tv/](https://connections-staging.internal.twitch.tv/)

dev = [https://connections-dev.internal.twitch.tv/](https://connections-dev.internal.twitch.tv/)

###Routes
[API Documentation](doc/api.md)

# Development
###Local
1) Start a local `redis-server`

2) Run `go run main.go`

3) Update dependencies with `make glide`


###Local Development with Fresh

Fresh will watch go files to test, lint, errcheck, and rebuild the local webserver on change.

```
go get -u github.com/golang/lint/golint
go get -u github.com/kisielk/errcheck
go get code.justin.tv/Kai-Hayashi/fresh
```

Run with `fresh`

Alternatively, to rebuild the server without testing, linting, and errchecking, use:

`fresh -c sprinter.conf`

###Staging & Production
Staging and Production environments reside in the `twitch-passport` AWS account within the `connections` Beanstalk application.

[Run Guide](doc/runbook.md)
