import javaposse.jobdsl.dsl.helpers.step.*

StepContext.metaClass.createBeanstalkArtifactFromFile = { String version, String s3Bucket, String applicationName ->
  shell """

export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
export AWS_DEFAULT_REGION=us-west-2

description=`git log --pretty=format:"%an - %ad: %s" --abbrev-commit -1 | cut -c 1-200`
aws s3 cp ${version}.zip s3://${s3Bucket}/apps/${applicationName}/${version}.zip
aws elasticbeanstalk create-application-version --no-auto-create-application --application-name ${applicationName} --version-label ${version} --description "\$description" --source-bundle S3Bucket=${s3Bucket},S3Key=apps/${applicationName}/${version}.zip
"""
}


job {
    name 'connections-build-eb-application-version'
    using 'TEMPLATE-autobuild'
    wrappers {
        credentialsBinding {
            string 'AWS_ACCESS_KEY', 'passport-builders-id'
	        string 'AWS_SECRET_KEY', 'passport-builders-secret'
            string 'JOB_DSL_SEED',   'job-dsl-seed'
        }
    }
    scm {
        git {
            remote {
                github 'identity/connections', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }

    // Bundle application version to store in S3 for Elastic Beanstalk
    steps {
        shell 'rm -rf .manta/'
        shell 'manta -v'
        shell 'cp .manta/connections .'
        shell """zip -r \$GIT_COMMIT.zip .ebextensions Procfile Buildfile connections"""
        createBeanstalkArtifactFromFile "\$GIT_COMMIT", 'twitch-identity-s3', 'connections'
    }

    // Set build status on github
    publishers {
        githubCommitNotifier()
    }
}

job {
    name 'connections-coverage'
    using 'TEMPLATE-autobuild'
    wrappers {
        credentialsBinding {
            string 'AWS_ACCESS_KEY', 'passport-builders-id'
            string 'AWS_SECRET_KEY', 'passport-builders-secret'
            string 'JOB_DSL_SEED',   'job-dsl-seed'
        }
    }
    scm {
        git {
            remote {
                github 'identity/connections', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }
    steps {
        shell 'rm -rf .manta/'
        shell 'manta -v -f .manta_coverage.json'
    }

    publishers {
        reportQuality('identity/connections', '.manta')
    }
}
