job {
    name 'systems-sandstorm-build'
    using 'TEMPLATE-autobuild'

    /**
     * credentials required for running tests with manta
     */
    wrappers {
      credentialsBinding {
        string 'AWS_SECRET_ACCESS_KEY', 'sse_sandstorm_aws_secret_access'
        string 'AWS_ACCESS_KEY_ID', 'sse_sandstorm_aws_access_id'
        string 'dta_tools_deploy', 'dta_tools_deploy'
        file('COURIERD_PRIVATE_KEY', 'courierd')
        file('AWS_CONFIG_FILE', 'aws_config')
      }
      environmentVariables {
        env('ENVIRONMENT', 'development')
      }
    }


    scm {
        git {
            remote {
                github 'systems/sandstorm', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            githubPolling(false)
        }
    }

    triggers {
      githubPush {
        githubPolling(false)
      }
    }

    steps {
        shell 'bash ./jenkins/build.sh'
        // this is from https://git-aws.internal.justin.tv/release/jenkins-jobs/blob/master/1templates/base.groovy
        saveDeployArtifact 'systems/sandstorm', 'build'
    }
    publishers {
        archiveArtifacts {
            pattern('.manta/*.log')
            allowEmpty()
        }
    }
}

job {
    name 'systems-sandstorm-full-test'
    using 'TEMPLATE-autobuild'

    /**
     * credentials required for running tests with manta
     */
    wrappers {
      credentialsBinding {
        string 'AWS_SECRET_ACCESS_KEY', 'sse_sandstorm_aws_secret_access'
        string 'AWS_ACCESS_KEY_ID', 'sse_sandstorm_aws_access_id'
        string 'dta_tools_deploy', 'dta_tools_deploy'
        file('COURIERD_PRIVATE_KEY', 'courierd')
        file('AWS_CONFIG_FILE', 'aws_config')
      }
      environmentVariables {
        env('ENVIRONMENT', 'development')
      }
    }


    scm {
        git {
            remote {
                github 'systems/sandstorm', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            githubPolling(false)
        }
    }


    triggers {
      githubPush {
        githubPolling(false)
      }
    }


    steps {
        shell 'bash ./jenkins/coverage.sh'
    }
    publishers {
        reportQuality('systems/sandstorm', 'build', '*.out')

        archiveArtifacts {
            pattern('build/*.log')
            pattern('test_report.xml')
            pattern('build/coverage.out')
            pattern('build/coverage.html')
            pattern('codecov_coverage.json')
            allowEmpty()
        }
        archiveJunit('test_report.xml') {
            allowEmptyResults()
        }
    }
}

job {
    name "systems-sandstorm-deploy"
    using 'TEMPLATE-deploy-aws'
    steps {
        shell 'courier deploy --repo systems/sandstorm --dir /opt/twitch/sandstorm'
    }
}

job {
    name "systems-sandstorm-cmd-aptly"
    parameters {
        stringParam 'GIT_COMMIT'
    }

    steps {
      downloadDeployArtifact 'systems/sandstorm'
      uploadDeb 'sandstorm-cli/precise/sandstorm.deb', 'precise'
      uploadDeb 'sandstorm-cli/xenial/sandstorm.deb', 'xenial'
      uploadWin('sandstorm-cli/windows/sandstorm.exe', 'sandstorm-cli/version')
      shell 'bash scripts/cli_s3_upload.sh'
    }
    wrappers {
      sshAgent 'git-aws-read-key'
      preBuildCleanup()
      timestamps()
      credentialsBinding {
        string 'AWS_SECRET_ACCESS_KEY', 'twitch-sandstorm-aws-jenkins-sandstormCLI-upload-key'
        string 'AWS_ACCESS_KEY_ID', 'twitch-sandstorm-aws-jenkins-sandstormCLI-upload-id'
        file('AWS_CONFIG_FILE', 'aws_config')
        string 'dta_tools_deploy', 'dta_tools_deploy'
      }
    }
}

// Sandstorm-Agent related jobs
job {
    name 'systems-sandstorm-agent-aptly'
    parameters {
      stringParam 'GIT_COMMIT'
    }
    steps {
      downloadDeployArtifact 'systems/sandstorm'
      uploadDeb 'sandstorm-agent/production/monit/sandstorm-agent-monit.deb', 'precise'
      uploadDeb 'sandstorm-agent/production/monit/sandstorm-agent-monit.deb', 'trusty'
      uploadDeb 'sandstorm-agent/production/systemd/sandstorm-agent-systemd.deb', 'xenial'
      uploadRPM('sandstorm-agent/production/redhat/sandstorm-agent-monit.rpm')
      shell 'bash scripts/agent_s3_upload.sh'
    }
    wrappers {
      preBuildCleanup()
      timestamps()
      credentialsBinding {
        string 'AWS_SECRET_ACCESS_KEY', 'sandstorm-agent-rpm-s3-secret-key'
        string 'AWS_ACCESS_KEY_ID', 'sandstorm-agent-rpm-s3-access-key'
        file('AWS_CONFIG_FILE', 'aws_config')
        string 'dta_tools_deploy', 'dta_tools_deploy'
      }
    }
}

job {
    name 'systems-sandstorm-agent-aptly-canary'
    parameters {
      stringParam 'GIT_COMMIT'
    }
    steps {
      downloadDeployArtifact 'systems/sandstorm'
      uploadDeb 'sandstorm-agent/canary/monit/sandstorm-agent-canary-monit.deb', 'precise'
      uploadDeb 'sandstorm-agent/canary/monit/sandstorm-agent-canary-monit.deb', 'trusty'
      uploadDeb 'sandstorm-agent/canary/systemd/sandstorm-agent-canary-systemd.deb', 'xenial'
      uploadRPM('sandstorm-agent/canary/redhat/sandstorm-agent-canary-monit.rpm')
    }
    wrappers {
      preBuildCleanup()
      timestamps()
      credentialsBinding {
        file('AWS_CONFIG_FILE', 'aws_config')
        string 'dta_tools_deploy', 'dta_tools_deploy'
      }
    }
}

job {
    name 'systems-sandstorm-agent-artifactory-staging'
    parameters {
      stringParam 'GIT_COMMIT'
    }
    steps {
      downloadDeployArtifact 'systems/sandstorm'
      uploadDeb 'sandstorm-agent/staging/monit/sandstorm-agent-staging-monit.deb', 'precise'
      uploadDeb 'sandstorm-agent/staging/monit/sandstorm-agent-staging-monit.deb', 'trusty'
      uploadDeb 'sandstorm-agent/staging/systemd/sandstorm-agent-staging-systemd.deb', 'xenial'
      uploadRPM('sandstorm-agent/staging/redhat/sandstorm-agent-staging-monit.rpm')
    }
    wrappers {
      preBuildCleanup()
      timestamps()
      credentialsBinding {
        file('AWS_CONFIG_FILE', 'aws_config')
        string 'dta_tools_deploy', 'dta_tools_deploy'
      }
    }
}

job {
    name 'systems-sandstorm-deploy-inventory-lambda-testing'
    parameters {
      stringParam 'GIT_COMMIT'
    }
    wrappers {
      preBuildCleanup()
      timestamps()
      credentialsBinding {
        // this aws config has the profile to download the deploy artifacts
        file('AWS_CONFIG_FILE', 'aws_config')
        string 'AWS_SECRET_ACCESS_KEY', 'sse_sandstorm_aws_secret_access'
        string 'AWS_ACCESS_KEY_ID', 'sse_sandstorm_aws_access_id'
      }
    }
    steps {
      downloadDeployArtifact 'systems/sandstorm'
      shell 'bash ./jenkins/deploy-inventory-lambda-testing.sh'
    }
}

job {
    name 'systems-sandstorm-deploy-inventory-lambda-staging'
    parameters {
      stringParam 'GIT_COMMIT'
    }
    wrappers {
      preBuildCleanup()
      timestamps()
      credentialsBinding {
        // this aws config has the profile to download the deploy artifacts
        file('AWS_CONFIG_FILE', 'aws_config')
        string 'AWS_SECRET_ACCESS_KEY', 'sse_sandstorm_aws_secret_access'
        string 'AWS_ACCESS_KEY_ID', 'sse_sandstorm_aws_access_id'
      }
    }
    steps {
      downloadDeployArtifact 'systems/sandstorm'
      shell 'bash ./jenkins/deploy-inventory-lambda-staging.sh'
    }
}

job {
    name 'systems-sandstorm-deploy-inventory-lambda-production'
    parameters {
      stringParam 'GIT_COMMIT'
    }
    wrappers {
      preBuildCleanup()
      timestamps()
      credentialsBinding {
        // this aws config has the profile to download the deploy artifacts
        file('AWS_CONFIG_FILE', 'aws_config')
        string 'AWS_SECRET_ACCESS_KEY', 'sse_sandstorm_aws_secret_access'
        string 'AWS_ACCESS_KEY_ID', 'sse_sandstorm_aws_access_id'
      }
    }
    steps {
      downloadDeployArtifact 'systems/sandstorm'
      shell 'bash ./jenkins/deploy-inventory-lambda-production.sh'
    }
}
