Cohesion
======

[![GoDoc](http://godoc.internal.justin.tv/code.justin.tv/web/cohesion?status.png)](http://godoc.internal.justin.tv/code.justin.tv/web/cohesion)

Relationships for all.


## Design

Cohesion allows consumers to represent many types of relationships as a graph, while offering basic query functionality, optimized for high read throughput.

**Entities** are typed nodes, such as users, teams, or comments. They may contain properties, which can be updated individually alongside the entity as a whole.

**Associations** are directed edges between entities, for instance the follow relationship between two users. For use cases where querying in the inverse direction is desired, Cohesion can manage the inverse edges for you. For instance, creating a `follows` association will automatically create the `followed_by` association in the opposite direction. We will also support symmetric bidirectional associations in the future (ex. friends).

Associations are stored with a timestamp, which determines the ordering of queries.

Cohesion does not support arbitrary graph traversal to guarantee performance characteristics; entities can only be queried by ID or through an association.

For usage instructions, see [usage.md](doc/usage.md).

See the [data model documentation](doc/data_model.md) for a more in-depth explanation of the implementation and the [original spec](https://twitch.hackpad.com/Follows-Service-USdzfcQHVvV) for use cases.

For background, see the [Facebook TAO](https://www.facebook.com/notes/facebook-engineering/tao-the-power-of-the-graph/10151525983993920) post, which served as inspiration for this service.

## API

See [API.doc](doc/api.md)

## Kinesis Replay Script

See [here](cmd/replay)


Development
-----------

You'll need to get set up with Go: https://twitchtv.atlassian.net/wiki/display/ENG/questions/97779808/how-do-i-install-go

You'll also need `gen`

    go get github.com/clipperhouse/gen

If you update the interface bodies in `datastore/interface.go`, you'll need to regen migration tools:

    cd ./datastore
    gen

### Integration Tests

manta runs integration tests for you.

Running manta in VM (tested on OS X only):

1. Install [VirtualBox](https://www.virtualbox.org/wiki/Downloads)
2. Install [Vagrant](https://www.vagrantup.com/downloads.html)
3. In your terminal run `vagrant up` (this may take a few minutes)
4. After the VM has been set up, run `vagrant ssh`
5. Look at **config.vm.synced_folder** in [Vagrantfile](Vagrantfile) to find where the mount is
located in the VM is located (for cohesion it is **/go/src/code.justin.tv/web/cohesion**)
6. In the VM run `cd [synced_folder]`
7. Finally, run `manta` and the build should start

