package associations

// Comparable interface provides the Equal function, which allows
// implementations to report whether they're equal in value to another instance
// or not
type Comparable interface {
	Equals(Comparable) bool
}

// CountResult is a proxy to int which lets us implement the
// Comparable interface
type CountResult int

// Equals returns true if the provided CountResult is equal to this CountResult
func (a CountResult) Equals(b Comparable) bool {
	return a == b
}

// AssocResponseSet wraps a []*AssocResponse such that it can
// implement the Comparable interface
type AssocResponseSet []*AssocResponse

// Equals returns true if the provided AssocResponseSet equals this
// AssocResponseSet.
func (a AssocResponseSet) Equals(in Comparable) bool {
	// TODO: permit returning error type for better understanding of miss types
	if b, ok := in.(AssocResponseSet); ok {
		if len(a) != len(b) {
			return false
		}
		for i := range a {
			if !a[i].Equals(b[i]) {
				return false
			}
		}
		return true
	}
	return false
}

// AssocResponseWithMetaSet wraps a []*AssocResponseWithMeta such that it can
// implement the Comparable interface.
type AssocResponseWithMetaSet []*AssocResponseWithMeta

// Equals returns true if the AssocResponseWithMetaSet equals this AssocResponseWithMeta.
func (a AssocResponseWithMetaSet) Equals(in Comparable) bool {
	// TODO: permit returning error type for better understanding of miss types
	if b, ok := in.(AssocResponseWithMetaSet); ok {
		if len(a) != len(b) {
			return false
		}
		for i := range a {
			if !a[i].Equals(b[i]) {
				return false
			}
		}
		return true
	}
	return false
}
