package associations

import (
	"testing"
	"time"

	. "github.com/smartystreets/goconvey/convey"
)

func init() {
	InitTestSchema()
}

func TestCountResultComparable(t *testing.T) {
	Convey("CountResults compare correctly", t, func() {
		one := CountResult(1)
		oneB := CountResult(1)
		two := CountResult(2)

		So(one.Equals(one), ShouldBeTrue)
		So(one.Equals(oneB), ShouldBeTrue)
		So(one.Equals(two), ShouldBeFalse)
	})
}

func TestAssocResponseSetComparable(t *testing.T) {
	Convey("AssocResponseSet compare correctly", t, func() {
		now := time.Now()
		emptyDataBag := make(map[string]interface{})

		a := &AssocResponse{E: &Entity{ID: "1", Kind: UserKind}, T: now, D: emptyDataBag}
		b := &AssocResponse{E: &Entity{ID: "2", Kind: UserKind}, T: now, D: emptyDataBag}
		c := &AssocResponse{E: &Entity{ID: "3", Kind: UserKind}, T: now, D: map[string]interface{}{"foo": "bar"}}
		// Same entity as c, different databag == different association
		d := &AssocResponse{E: &Entity{ID: "3", Kind: UserKind}, T: now, D: map[string]interface{}{"foo": 1}}
		e := &AssocResponse{E: &Entity{ID: "3", Kind: UserKind}, T: now, D: map[string]interface{}{"foo": 1}}

		Convey("ordering", func() {
			base := AssocResponseSet([]*AssocResponse{a, d})
			same := AssocResponseSet([]*AssocResponse{a, e})
			wrong := AssocResponseSet([]*AssocResponse{d, a})
			So(base.Equals(same), ShouldBeTrue)
			So(base.Equals(wrong), ShouldBeFalse)
		})

		Convey("length", func() {
			base := AssocResponseSet([]*AssocResponse{a, b})
			same := AssocResponseSet([]*AssocResponse{a, b})
			wrong := AssocResponseSet([]*AssocResponse{a, b, c})
			So(base.Equals(same), ShouldBeTrue)
			So(base.Equals(wrong), ShouldBeFalse)
		})

		Convey("databag check", func() {
			base := AssocResponseSet([]*AssocResponse{c})
			wrong := AssocResponseSet([]*AssocResponse{d})
			So(base.Equals(wrong), ShouldBeFalse)
		})
	})
}
