package associations

import (
	"fmt"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

func init() {
	InitTestSchema()
}

func TestErrors(t *testing.T) {
	Convey("ErrAssociationExists returns the default error message if not initialized with an error", t, func() {
		e := ErrAssociationExists{}
		So(e.Error(), ShouldEqual, "Association already exists")

		e = ErrAssociationExists{Source: fmt.Errorf("testing")}
		So(e.Error(), ShouldEqual, "testing")
	})
}
