package associations

import "log"

// UserKind is a test EntityKind
var UserKind EntityKind

// FollowsKind is a test AssocKind
var FollowsKind AssocKind

// TestKind is a test EntityKind
var TestKind EntityKind

// FollowedByKind is a test AssocKind
var FollowedByKind AssocKind

var testKindsInitialized bool

// InitTestSchema loads the test schema for the unit tests throughout Cohesion
// Should be run in each test file.
func InitTestSchema() {
	if testKindsInitialized {
		return
	}

	var err error
	SchemaManager, err = NewSchemaManager("test")
	if err != nil {
		log.Fatal(err.Error())
	}

	UserKind, _ = SchemaManager.EntityKind("user")
	FollowsKind, _ = SchemaManager.AssocKind("follows")
	FollowedByKind, _ = SchemaManager.AssocKind("followed_by")
	TestKind, _ = SchemaManager.EntityKind("test")

	testKindsInitialized = true
}
