cohesion-go
===========

## Warning

Immature library not yet used in production, use with caution and submit fixes!

## Versioning

Use a package management tool to protect yourself from breaking changes:
https://github.com/golang/go/wiki/PackageManagementTools

## HTTP Clients

You can create 2 types of HttpClients, a default one or a custom client.
The default client includes statsd integration as well as support for context for all cohesion client calls.
It requires a prefix for the statsD library as well as the statsD object. [Cactus-go](https://github.com/cactus/go-statsd-client)
is the preferred statsD library.

```go
stats, _ := statsd.NewNoopClient()
httpClient := DefaultHTTPClient(stats, "test")
```

### Custom HTTP client

```go
opt := CustomHTTPClient(func(ctx context.Context) *http.Client {
  client := ... custom code here ...
  return client
})
```

## Cohesion Client Setup

A call to `NewClient` will generate a new Cohesion client.

Arguments:
 * A `hostName`
 * An HTTP Client generated from either `DefaultHTTPClient` or `CustomHTTPClient`. 
 * A `schema`
 * Optional functions to set a repository.

The `schema` argument specifies which [schema](https://git-aws.internal.justin.tv/web/cohesion/tree/master/schema) to use. The file that's loaded is `schema` + ".json".  Schemas specify what the valid values are for each request parameter when making requests to Cohesion.

```go
stats, _ := statsd.NewNoopClient()

httpClient := DefaultHTTPClient(stats, "test")
client, err := NewClient(server.URL, httpClient, "follows", SetRepository("chat/tmi"))

```

## Deploying an App to Production that Uses the Cohesion Client

The cohesion client loads schema definitions from the local filesystem.  Thus, as a part of your deploy process you will need to include the schema files.  If you're using manta, you will want to add something like the following to your build step:

```
 "build": [
    ...
    "mkdir -p /build/schema",
    "cp Godeps/_workspace/src/code.justin.tv/web/cohesion/schema/<your_schema>.json /build/schema/<your_schema>.json"
  ],
```

