package v2

import (
	"code.justin.tv/web/cohesion/associations"
	"golang.org/x/net/context"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
)

func (c *v2Client) Update(ctx context.Context, from Entity, kind string, to Entity, newAssocKind string, databag map[string]interface{}) error {
	requestBody := map[string]interface{}{
		"data_bag": databag,
	}

	if newAssocKind != "" {
		requestBody["new_assoc_kind"] = newAssocKind
	}

	request, err := c.newRequest(from, kind, to, requestBody)
	if err != nil {
		return err
	}

	_, err = c.conn.Update(ctx, request)
	if err != nil && grpc.Code(err) == codes.NotFound {
		err = associations.ErrNotFound{}
	}

	return err
}

func (c *v2Client) BulkUpdate(ctx context.Context, from Entity, kind string, bulkKind string, newAssocKind string, databag map[string]interface{}) error {
	requestBody := map[string]interface{}{
		"data_bag": databag,
	}

	if newAssocKind != "" {
		requestBody["new_assoc_kind"] = newAssocKind
	}

	request, err := c.newBulkRequest(from, kind, bulkKind, requestBody)
	if err != nil {
		return err
	}

	_, err = c.conn.Update(ctx, request)
	if err != nil && grpc.Code(err) == codes.NotFound {
		err = associations.ErrNotFound{}
	}

	return err
}

func (c *v2Client) BatchUpdate(ctx context.Context, from Entity, kind string, bulkKind string, data map[string]interface{}) error {
	request, err := c.newBatchRequest(from, kind, bulkKind, data)
	if err != nil {
		return err
	}

	_, err = c.conn.Update(ctx, request)
	if err != nil && grpc.Code(err) == codes.NotFound {
		err = associations.ErrNotFound{}
	}

	return nil
}
