package models

import "time"

// PartnerProperties holds all partner properties of a partner
type PartnerProperties struct {
	ID                         *int       `json:"-"`
	UserID                     *int       `json:"user_id"`
	PartnerProgram             *bool      `json:"partner_program"`
	PartnerProgramJoinDate     *time.Time `json:"partner_program_join_date"`
	TwitchLiverailID           *int       `json:"twitch_liverail_id"`
	PartnerLiverailID          *int       `json:"partner_liverail_id"`
	TeespringConnectEnabled    *bool      `json:"teespring_connect_enabled"`
	BitsContractAmendmentState *string    `json:"bits_contract_amendment_state"`
	PartnerPreferredEmail      *string    `json:"partner_preferred_email"`
	CreatedAt                  *time.Time `json:"created_at"`
	UpdatedAt                  *time.Time `json:"updated_at"`
}

// BulkPartnerProperties holds partner properties of multiple partners
type BulkPartnerProperties struct {
	Results              []*PartnerProperties `json:"results"`
	NextExclusiveStartID *int                 `json:"next_exclusive_start_id,omitempty"`
}
