# Users Service

Users Service provides property access and business logic for core "user" properties

## API

Please see the [API documentation](doc/api.md).

## Accesing Users Service

Users Service's production environment is currently restricted to access from Twitch EC2 instances. This means you can rest assured that https://users-service.prod.us-west2.twitch.tv is accessible from within your production service's networks. 99% of the time, you should be hitting users's service staging environment with your local environment.

However, if you do need to access user service's production environment for local development of services that are dependent, one option is to run a local port forward via an existing ec2 instance in staging.

e.g.

    ssh -L 9999:users-service.prod.us-west2.twitch.tv:80 <hostnameofanec2instanceinstaging>

This will then allow you to hit http://localhost:9999/users?id=1 and other endpoints from your local environment. For maximum convenience, maybe run this in a tmux session and detatch.

**Please do not create any persistent shims to users service that don't require some form of secure authentication. For example, SSH can be made to expose a port forward globally from one of your ec2 instances so that all local devs could just hit that and never run their own tunnel. This defeats the purpose of gating users service access outside of AWS behind SSH authentication and opens Twitch up to security issues.**

## Build

    go build

I'd recommend you use manta for building however the above will
produce a users-service binary you can use.

## Testing

Unit tests can be run as follows

	go test ./...
	
Integration tests rely on [Manta](https://git-aws.internal.justin.tv/release/manta-style#installation). If manta is configured, you can run the following:

    manta -v -f build.json

Test coverage is significantly less than 100% and should be used as supplemental not exclusive testing.

Mocks were created using

https://github.com/vektra/mockery

To regenerate do something like

    go get github.com/vektra/mockery/...
    go generate ./...

## How to run

     # In a separate terminal run
     ssh -L 14912:redis-14912.us-west-mz.4.redislabs.twitch.tv:14912 users-service-aws-0fc47b7ee35d26fb3.dev.us-west2.justin.tv

     # then run
    ./users-service

This will run a local copy against a local database.

The assumption here is you have a database running on `localhost:5432` which
has a un:pw of `users:users` and a database named `users`. The easiest way to
get this up and running (assuming docker is installed) is:

    docker run -p 5432:5432 -e POSTGRES_PASSWORD=users -e POSTGRES_USER=users -d postgres
    psql -h 127.0.0.1 -p 5432 -U users < build/loader.sql

If you need to generate the dump files again please do the following
against a staging database (from the project root):

    pg_dump -xOs -h master-sitedb.staging.sfo01.justin.tv -p 6543 -U site_02 justintv_dev -t users -t user_moderation_properties -t user_role_properties -t user_email_properties -t user_phone_number_properties > build/01_schema_dump.sql
    psql -h master-sitedb.staging.sfo01.justin.tv -p 6543 -U site_02 justintv_dev < build/dumper.sql

## Development - Mac OS X

Running [manta](https://git-aws.internal.justin.tv/release/manta-style)

```bash
manta -v -f build.json
```

Install GeoIP db:

```bash
brew install geoip
wget -N http://geolite.maxmind.com/download/geoip/database/GeoLiteCountry/GeoIP.dat.gz
gunzip GeoIP.dat.gz
mkdir -p /usr/local/share/GeoIP/
mv GeoIP.dat /usr/local/share/GeoIP/
```

Then, to run the server:

```bash
echo localhost:5432:users:users > .dbpass_dev
.manta/users-service
// you should now be able to access the users-service running in vagrant from your dev environment at localhost:8080
// you will likely need to install, configure, and load database dumps for postgres / redis
```
## Run terraform
We currently have remote state for terraform 0.8.6 and the remote state is stored in S3 for our dev and prod account. 

Run terraform for prod (under terraform/production):
```
AWS_PROFILE=twitch-web-aws AWS_DEFAULT_REGION=us-west-2 sh bootstrap.sh
AWS_DEFAULT_REGION=us-west-2 AWS_PROFILE=twitch-web-aws terraform plan --out=foo
AWS_DEFAULT_REGION=us-west-2 AWS_PROFILE=twitch-web-aws terraform apply foo
```

Run terraform for dev (under terraform/dev):
```
AWS_PROFILE=twitch-web-dev AWS_DEFAULT_REGION=us-west-2 sh bootstrap.sh
AWS_DEFAULT_REGION=us-west-2 AWS_PROFILE=twitch-web-dev terraform plan --out=foo
AWS_DEFAULT_REGION=us-west-2 AWS_PROFILE=twitch-web-dev terraform apply foo
```

The bootstrap script will set up remote state, grab everything updated to prepare for your runs. It is helpful to submit a pr with your terraform plan result before actually running on prod. 

## Update vendor
Users-service is using glide to do vendoring. Add your new vendor to glide.yaml file.

Then run a vendor update
```
make vendor
```

If `make vendor` fails due to a specific mock, delete that existing mock file and then rerun `make vendor`.
