freeStyleJob('web-users-service') {
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'web/users-service', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }
  steps {
    shell 'manta -v -f build.json -update'
    saveDeployArtifact 'web/users-service', '.manta'
  }
}

freeStyleJob('web-users-service-deploy') {
  using 'TEMPLATE-deploy-aws'
  steps {
    shell 'courier deploy --repo web/users-service --dir /opt/twitch/users-service'
  }
}
 