# following-service [DEPRECATED]

This service is deprecated. Use [fulton following service](https://code.amazon.com/packages/TwitchVXFollowingServiceECS) instead.

<a target="_blank" href="https://eventbus.xarth.tv/events#UserFollowUserCreate"><img src="https://event-bus-badges.s3-us-west-2.amazonaws.com/UserFollowUserCreate.svg"></a><br>

[![codecov](https://codecov.xarth.tv/ghe/feeds/following-service/branch/master/graph/badge.svg)](https://codecov.xarth.tv/ghe/feeds/following-service)

Following Service is a service which manages follow relationships between users (e.g. following or unfollowing a user.) It's fairly lightweight, and is more or less a direct passthrough to [Cohesion](https://git.xarth.tv/web/cohesion).

## Getting Started

1. [Install Go](https://golang.org/doc/install)
2. `go get -d code.justin.tv/feeds/following-service`
3. Set Up
  - ```make setup```
  - [Configure Your AWS Credentials](http://docs.aws.amazon.com/cli/latest/userguide/cli-chap-getting-started.html)
  - export AWS_PROFILE=twitch-feed-dev
4. Run Tests / Linter
  ```
  make test
  make lint
  ```
5. Run Server
  ```
  make dev
  ```

## Configuration

Configuration is performed via the [Config](https://git.xarth.tv/common/config) library.

1. **cohesion-HostName**
  - A host where a cohesion instance can be found.
  - default: **cohesion-follows-elb.staging.us-west2.justin.tv**
2. **cohesion-Port**
  - A port to use to connect to cohesion.
  - default: **8001**

## Mocks

Generating mocks can be done with this command:
```sh
make mocks
```

## Integration tests

To run integration tests against staging:
```sh
make integration_test
```

You can modify integration_test_endpoint.json to add more integration test environments, including localhost if you want.

## Terraform
Please make sure you're using at least the following version: `0.12.26`. [chtf](https://github.com/Yleisradio/homebrew-terraforms) is a useful tool to switch between multiple terraform versions


Make sure your `~/.ssh/config` file is setup properly to handle requests to `git.xarth.tv`. And run `mwinit --aea` before running any terraform commands.

```bash
$ cat ~/.ssh/config
host git-aws.internal.justin.tv git.xarth.tv
    ProxyJump [AMAZON_USER_NAME]@bastion.git.xarth.tv
$ mwinit --aea
```
[Ref](https://wiki.twitch.com/pages/viewpage.action?pageId=224695468#ConnectingtoGithubEnterprise(GHE)-gitOperationsoverSSH)
 


## API 

**Hosts**

| Environment | HTTPS |
|-------------|-----|
| Staging | https://staging.following-service.twitch.a2z.com |
| Production | https://production.following-service.twitch.a2z.com |

**Endpoints**

See the available endpoints in [service.proto](rpc/followsrpc/service.proto) and example request for each endpoint in [api.md](api.md)

**Service-level objectives**

See the latency SLOs for each endpoint in [service.proto](rpc/followsrpc/service.proto).

## SNS Updates

**SendUpdateFollowMessage** is represented by the following message:

```
type updateFollowMessage struct {
	FromUserID          string    `json:"from_id"`
	TargetUserID        string    `json:"target_id"`
	Event               string    `json:"event"`
	UpdatedAt           time.Time `json:"updated_at"`
	TargetFollowerCount *int      `json:"target_follower_count,omitempty"`
}
```

Note that `TargetFollowerCount` is of type `*int`, so the zero value for this field is `nil`.
`Event` will map to either `"follow"` or `"unfollow"`, depending on the action performed.

The **ARNs** for the SNS topics are as follows:<br/>
**Staging**: `arn:aws:sns:us-west-2:724951484461:following-service_staging_updatefollow_notifications`<br/>
**Production**: `arn:aws:sns:us-west-2:914569885343:following-service_production_updatefollow_notifications`

## Pubsub

**SendFollowPubSubMessage** publishes all follows to a userID under the topic `following.<userID>`.
To subscribe, follow the instructions laid out in the [Twitch docs](https://dev.twitch.tv/docs/v5/guides/PubSub/#subscribing-to-topics). The message structure is:

```
{
  "type":"MESSAGE",
  "data":{
    "topic":"following.<userID>",
    "message":"{\"display_name\":\"<follower_displayName>\",\"username\":\"<follower_userName>\",\"user_id\":\"<follower_userID>\"}"
    }
}
```

## Deploying
[Deploy Steps](deployment.md)

## Architecture
[Architecture Diagram](docs/architecture_diagram.png)

## FYI
- Left Navigation is displying [100 followed channels](https://git.xarth.tv/twilight/twilight/blob/master/src/features/side-nav/components/followed-channels/component.tsx#L284-L285) at most.

### Expected Callers
The below dependencies are expected to continue calling the old non-twirp API through the depreciation process. Teams have given us the ok to deprecate the API even if it might broke the endpoint.

#### Recommendation
`bakend.GetFollows` calls [Follows.ListFollows](https://git.xarth.tv/discovery/recommendations/blob/master/backend/clients.go#L172), which is eventually called through these APIs:
- [GetOnboardingChannels](https://git.xarth.tv/discovery/recommendations/blob/master/logic/onboarding_channels_logic.go#L30) 
- [GetSocialRecommendationsForUser](https://git.xarth.tv/discovery/recommendations/blob/master/logic/user_social_recommendations_logic.go#L13)

## SSH Access
Following service doesn't have a dedicated jumpbox. Connect to the Twitch VPN and ssh to any instance on the account.
