# Following-Service API

### GetFollow
Perform a post request to twirp/code.justin.tv.feeds.following.followsrpc.Follows/GetFollow
to loads data about a user following a target user. If it does not exist, a 404 is returned

Example Request
```
curl -XPOST http://staging.following-service.twitch.a2z.com/twirp/code.justin.tv.feeds.following.followsrpc.Follows/GetFollow -d '{"from_user_id":"123", "target_user_id":"456"}' -H "Content-Type: application/json"
```

### GetBatchFollows
Perform a post request to twirp/code.justin.tv.feeds.following.followsrpc.Follows/GetBatchFollows
to loads data about a user following a list of users

Example Request
```
 curl -XPOST http://staging.following-service.twitch.a2z.com/twirp/code.justin.tv.feeds.following.followsrpc.Follows/GetBatchFollows -d '{"from_user_id": "123", "target_user_ids": ["456", "1234"]}' -H "Content-Type: application/json"
```
### ListFollows
Perform a post request to twirp/code.justin.tv.feeds.following.followsrpc.Follows/ListFollows
to loads data about users followed by user_id. `cursor`, `limit`, and `direction` can be specified as query parameter. `directoon` can either be `asc` or `desc`

Example Request
```
curl -XPOST http://staging.following-service.twitch.a2z.com/twirp/code.justin.tv.feeds.following.followsrpc.Follows/ListFollows -d '{"user_id":"123", "limit":2}' -H "Content-Type: application/json"
```

### ListFollowers
Perform a post request to twirp/code.justin.tv.feeds.following.followsrpc.Follows/ListFollowers
to loads data about users that are following user_id. `cursor`, `limit`, and `direction` can be specified as query parameter. `directoon` can either be `asc` or `desc`

Example Request
```
curl -XPOST http://staging.following-service.twitch.a2z.com/twirp/code.justin.tv.feeds.following.followsrpc.Follows/ListFollowers -d '{"user_id":"123", "limit":2}' -H "Content-Type: application/json"
```

### CountFollows
Perform a post request to twirp/code.justin.tv.feeds.following.followsrpc.Follows/CountFollows
to receive the count of users followed by user_id.

Example Request
```
curl -XPOST http://staging.following-service.twitch.a2z.com/twirp/code.justin.tv.feeds.following.followsrpc.Follows/CountFollows -d '{"user_id":"123"}' -H "Content-Type: application/json"
```

### CountFollowers
Perform a post request to twirp/code.justin.tv.feeds.following.followsrpc.Follows/CountFollowers
to receive the count of user that are following user_id.

Example Request
```
curl -XPOST http://staging.following-service.twitch.a2z.com/twirp/code.justin.tv.feeds.following.followsrpc.Follows/CountFollows -d '{"user_id":"123"}' -H "Content-Type: application/json"
```

### BatchCountFollower
Perform a post request to twirp/code.justin.tv.feeds.following.followsrpc.Follows/BatchCountFollowers
to receive a list of follower count for every user

Example Request
```
curl -XPOST http://staging.following-service.twitch.a2z.com/twirp/code.justin.tv.feeds.following.followsrpc.Follows/BatchCountFollowers -d '{"user_ids": ["1234", "123"]}' -H "Content-Type: application/json
```
### UpsertFollow
Perform a post request to twirp/code.justin.tv.feeds.following.followsrpc.Follows/UpsertFollow
to create or update a follow relationship between from_user_id and target_user_id. `{ block_notifications: true }` is optional, and defaults to false.

Example Request
```
curl -XPOST http://staging.following-service.twitch.a2z.com/twirp/code.justin.tv.feeds.following.followsrpc.Follows/UpsertFollow -d '{"from_user_id":"123", "target_user_id":"456"}' -H "Content-Type: application/json"
```

### DeleteFollow
Perform a post request to twirp/code.justin.tv.feeds.following.followsrpc.Follows/DeleteFollow
to deletes a follow relationship between from_user_id and target_user_id

Example Request
```
curl -XPOST http://staging.following-service.twitch.a2z.com/twirp/code.justin.tv.feeds.following.followsrpc.Follows/DeleteFollow -d '{"from_user_id":"123", "target_user_id":"456"}' -H "Content-Type: application/json"
```

### HideAllFollows
Perform a post request to twirp/code.justin.tv.feeds.following.followsrpc.Follows/HideAllFollow
to hide all followers and follows related to a user

Example Request
```
curl -XPOST http://staging.following-service.twitch.a2z.com/twirp/code.justin.tv.feeds.following.followsrpc.Follows/HideAllFollows -d '{"user_id":"123"}' -H "Content-Type: application/json"
```

### RestoreAllFollows
Perform a post request to twirp/code.justin.tv.feeds.following.followsrpc.Follows/RestoreAllFollow
to restore all hidden followers and follows related to a user

Example Request
```
curl -XPOST http://staging.following-service.twitch.a2z.com/twirp/code.justin.tv.feeds.following.followsrpc.Follows/RestoreAllFollows -d '{"user_id":"123"}' -H "Content-Type: application/json"
```