package backend

import (
	"context"
	"fmt"

	graphdbFulton "code.justin.tv/amzn/TwitchVXGraphDBECSTwirp"
	"code.justin.tv/feeds/following-service/clients"
	"github.com/afex/hystrix-go/hystrix"
)

func (b Backend) BulkUpdateFollows(ctx context.Context, userID string, limit int, edge, newEdge string) (bool, error) {
	var resp *graphdbFulton.BulkEdgeUpdateResponse
	err := hystrix.Do(clients.HystrixGraphDBBatch, func() (err error) {
		defer func() {
			if p := recover(); p != nil {
				err = fmt.Errorf("%s circuit panic=%v", clients.HystrixGraphDBBatch, p)
			}
		}()

		resp, err = b.GraphDBFultonClient.BulkEdgeUpdate(ctx, &graphdbFulton.BulkEdgeUpdateRequest{
			From: &graphdbFulton.Node{
				Type: UserKind,
				Id:   userID,
			},
			EdgeType:    edge,
			NewEdgeType: newEdge,
			Limit:       int32(limit),
		})
		if err != nil {
			return err
		}

		return nil
	}, nil)

	if err != nil {
		return false, err
	}
	return resp.More, err
}

func (b Backend) BulkDeleteFollows(ctx context.Context, userID string, limit int, edge string) (bool, error) {
	var resp *graphdbFulton.BulkEdgeDeleteResponse
	err := hystrix.Do(clients.HystrixGraphDBBatch, func() (err error) {
		defer func() {
			if p := recover(); p != nil {
				err = fmt.Errorf("%s circuit panic=%v", clients.HystrixGraphDBBatch, p)
			}
		}()

		resp, err = b.GraphDBFultonClient.BulkEdgeDelete(ctx, &graphdbFulton.BulkEdgeDeleteRequest{
			From: &graphdbFulton.Node{
				Type: UserKind,
				Id:   userID,
			},
			EdgeType: edge,
			Limit:    int32(limit),
		})
		if err != nil {
			return err
		}

		return nil
	}, nil)

	if err != nil {
		return false, err
	}
	return resp.More, err
}
