package backend

import (
	"context"
	"fmt"

	graphdbFulton "code.justin.tv/amzn/TwitchVXGraphDBECSTwirp"
	"code.justin.tv/feeds/following-service/clients"
	"github.com/afex/hystrix-go/hystrix"
)

func (b Backend) CountFollowers(ctx context.Context, userID string) (int, error) {
	count := 0
	err := hystrix.Do(clients.HystrixGraphDBCountFollowers, func() (err error) {
		defer func() {
			if p := recover(); p != nil {
				err = fmt.Errorf("%s circuit panic=%v", clients.HystrixGraphDBCountFollowers, p)
			}
		}()

		resp, err := b.GraphDBFultonClient.EdgeCount(ctx, &graphdbFulton.EdgeCountRequest{
			From: &graphdbFulton.Node{
				Type: UserKind,
				Id:   userID,
			},
			EdgeType: FollowersKind,
		})
		if err != nil {
			return err
		}

		count = int(resp.GetCount())
		return nil
	}, nil)
	return count, err
}
