package backend_test

import (
	"errors"
	"testing"

	graphdbFulton "code.justin.tv/amzn/TwitchVXGraphDBECSTwirp"
	"code.justin.tv/feeds/following-service/backend"
	"code.justin.tv/feeds/following-service/mocks"
	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/suite"
)

type CountFollowersSuite struct {
	suite.Suite
	backend backend.Backender
}

func (suite *CountFollowersSuite) SetupTest() {
	client := &mocks.TwitchVXGraphDBECS{}
	client.On("EdgeCount", mock.Anything, &graphdbFulton.EdgeCountRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "1",
		},
		EdgeType: backend.FollowersKind,
	}).Return(&graphdbFulton.EdgeCountResponse{
		Count: 500,
	}, nil)
	client.On("EdgeCount", mock.Anything, &graphdbFulton.EdgeCountRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "2",
		},
		EdgeType: backend.FollowersKind,
	}).Return(nil, errors.New("broken"))
	client.On("EdgeCount", mock.Anything, &graphdbFulton.EdgeCountRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "3",
		},
		EdgeType: backend.FollowersKind,
	}).Return(nil, nil).Run(func(args mock.Arguments) { panic("panic") })
	suite.backend = backend.Backend{
		GraphDBFultonClient: client,
		ErrorLogger:         NewNoopErrorLogger(),
	}
}

func (suite *CountFollowersSuite) TestSuccessfulRequest() {
	count, err := suite.backend.CountFollowers(nil, "1")
	suite.Nil(err)
	suite.Equal(500, count)
}

func (suite *CountFollowersSuite) TestFailedRequest() {
	count, err := suite.backend.CountFollowers(nil, "2")
	suite.EqualError(err, "broken")
	suite.Zero(count)
}

func (suite *CountFollowersSuite) TestPanic() {
	count, err := suite.backend.CountFollowers(nil, "3")
	suite.EqualError(err, "graphdb_countfollowers circuit panic=panic")
	suite.Zero(count)
}

func TestCountFollowersSuite(t *testing.T) {
	suite.Run(t, new(CountFollowersSuite))
}
