package backend

import (
	"context"
	"fmt"

	graphdbFulton "code.justin.tv/amzn/TwitchVXGraphDBECSTwirp"
	"code.justin.tv/feeds/following-service/clients"
	"github.com/afex/hystrix-go/hystrix"
)

func (b Backend) CountFollows(ctx context.Context, userID string) (int, error) {
	count := 0
	err := hystrix.Do(clients.HystrixGraphDBCountFollows, func() (err error) {
		defer func() {
			if p := recover(); p != nil {
				err = fmt.Errorf("%s circuit panic=%v", clients.HystrixGraphDBCountFollows, p)
			}
		}()

		resp, err := b.GraphDBFultonClient.EdgeCount(ctx, &graphdbFulton.EdgeCountRequest{
			From: &graphdbFulton.Node{
				Type: UserKind,
				Id:   userID,
			},
			EdgeType: FollowsKind,
		})
		if err != nil {
			return err
		}

		count = int(resp.GetCount())
		return nil
	}, nil)
	return count, err
}
