package backend_test

import (
	"errors"
	"testing"

	graphdbFulton "code.justin.tv/amzn/TwitchVXGraphDBECSTwirp"
	"code.justin.tv/feeds/following-service/backend"
	"code.justin.tv/feeds/following-service/mocks"
	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/suite"
)

type CountFollowsSuite struct {
	suite.Suite
	backend backend.Backender
}

func (suite *CountFollowsSuite) SetupTest() {
	client := &mocks.TwitchVXGraphDBECS{}
	client.On("EdgeCount", mock.Anything, &graphdbFulton.EdgeCountRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "1",
		},
		EdgeType: backend.FollowsKind,
	}).Return(&graphdbFulton.EdgeCountResponse{
		Count: 500,
	}, nil)
	client.On("EdgeCount", mock.Anything, &graphdbFulton.EdgeCountRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "2",
		},
		EdgeType: backend.FollowsKind,
	}).Return(nil, errors.New("broken"))
	client.On("EdgeCount", mock.Anything, &graphdbFulton.EdgeCountRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "3",
		},
		EdgeType: backend.FollowsKind,
	}).Return(nil, nil).Run(func(args mock.Arguments) { panic("panic") })
	suite.backend = backend.Backend{
		GraphDBFultonClient: client,
		ErrorLogger:         NewNoopErrorLogger(),
	}
}

func (suite *CountFollowsSuite) TestSuccessfulRequest() {
	count, err := suite.backend.CountFollows(nil, "1")
	suite.Nil(err)
	suite.Equal(500, count)
}

func (suite *CountFollowsSuite) TestFailedRequest() {
	count, err := suite.backend.CountFollows(nil, "2")
	suite.EqualError(err, "broken")
	suite.Zero(count)
}

func (suite *CountFollowsSuite) TestPanic() {
	count, err := suite.backend.CountFollows(nil, "3")
	suite.EqualError(err, "graphdb_countfollows circuit panic=panic")
	suite.Zero(count)
}

func TestCountFollowsSuite(t *testing.T) {
	suite.Run(t, new(CountFollowsSuite))
}
