package backend

import (
	"context"
	"fmt"

	graphdbFulton "code.justin.tv/amzn/TwitchVXGraphDBECSTwirp"
	"code.justin.tv/feeds/following-service/clients"
	"github.com/afex/hystrix-go/hystrix"
)

func (b Backend) DestroyUser(ctx context.Context, userID string) error {
	err := hystrix.Do(clients.HystrixGraphDBBulkDelete, func() (err error) {
		defer func() {
			if p := recover(); p != nil {
				err = fmt.Errorf("%s circuit panic=%v", clients.HystrixGraphDBBulkDelete, p)
			}
		}()

		_, gdbErr := b.GraphDBFultonClient.BulkEdgeDelete(ctx, &graphdbFulton.BulkEdgeDeleteRequest{
			From: &graphdbFulton.Node{
				Type: UserKind,
				Id:   userID,
			},
			EdgeType: FollowsKind,
		})
		return gdbErr
	}, nil)
	if err != nil {
		return err
	}

	return hystrix.Do(clients.HystrixGraphDBBulkDelete, func() (err error) {
		defer func() {
			if p := recover(); p != nil {
				err = fmt.Errorf("%s circuit panic=%v", clients.HystrixGraphDBBulkDelete, p)
			}
		}()

		_, gdbErr := b.GraphDBFultonClient.BulkEdgeDelete(ctx, &graphdbFulton.BulkEdgeDeleteRequest{
			From: &graphdbFulton.Node{
				Type: UserKind,
				Id:   userID,
			},
			EdgeType: FollowersKind,
		})
		return gdbErr
	}, nil)
}
