package backend_test

import (
	"errors"
	"testing"

	graphdbFulton "code.justin.tv/amzn/TwitchVXGraphDBECSTwirp"
	"code.justin.tv/feeds/following-service/backend"
	"code.justin.tv/feeds/following-service/mocks"
	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/suite"
)

type DestroyUserSuite struct {
	suite.Suite
	backend backend.Backender
}

func (suite *DestroyUserSuite) SetupTest() {
	client := &mocks.TwitchVXGraphDBECS{}
	suite.backend = backend.Backend{
		GraphDBFultonClient: client,
		ErrorLogger:         NewNoopErrorLogger(),
	}
	client.On("BulkEdgeDelete", mock.Anything, &graphdbFulton.BulkEdgeDeleteRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "1",
		},
		EdgeType: backend.FollowsKind,
	}).Return(nil, nil)
	client.On("BulkEdgeDelete", mock.Anything, &graphdbFulton.BulkEdgeDeleteRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "1",
		},
		EdgeType: backend.FollowersKind,
	}).Return(nil, nil)
	client.On("BulkEdgeDelete", mock.Anything, &graphdbFulton.BulkEdgeDeleteRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "2",
		},
		EdgeType: backend.FollowsKind,
	}).Return(nil, errors.New("broken"))
	client.On("BulkEdgeDelete", mock.Anything, &graphdbFulton.BulkEdgeDeleteRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "3",
		},
		EdgeType: backend.FollowsKind,
	}).Return(nil, nil)
	client.On("BulkEdgeDelete", mock.Anything, &graphdbFulton.BulkEdgeDeleteRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "3",
		},
		EdgeType: backend.FollowersKind,
	}).Return(nil, errors.New("broken2"))
	client.On("BulkEdgeDelete", mock.Anything, &graphdbFulton.BulkEdgeDeleteRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "4",
		},
		EdgeType: backend.FollowsKind,
	}).Return(nil, nil).Run(func(args mock.Arguments) { panic("panic") })
}

func (suite *DestroyUserSuite) TestSuccessfulRequest() {
	err := suite.backend.DestroyUser(nil, "1")
	suite.Nil(err)
}

func (suite *DestroyUserSuite) TestFailedRequestFollows() {
	err := suite.backend.DestroyUser(nil, "2")
	suite.NotNil(err)
	suite.EqualError(err, "broken")
}

func (suite *DestroyUserSuite) TestFailedRequestFollowers() {
	err := suite.backend.DestroyUser(nil, "3")
	suite.NotNil(err)
	suite.EqualError(err, "broken2")
}

func (suite *DestroyUserSuite) TestPanic() {
	err := suite.backend.DestroyUser(nil, "4")
	suite.NotNil(err)
	suite.EqualError(err, "graphdb_bulk_delete circuit panic=panic")
}

func TestDestroyUserSuite(t *testing.T) {
	suite.Run(t, new(DestroyUserSuite))
}
