package backend

import (
	"context"
	"fmt"

	graphdbFulton "code.justin.tv/amzn/TwitchVXGraphDBECSTwirp"
	"code.justin.tv/feeds/following-service/clients"
	"github.com/afex/hystrix-go/hystrix"
)

func (b Backend) GetBatchFollows(ctx context.Context, fromUserID string, targetUserIDs []string) ([]*graphdbFulton.EdgeGetResponse, error) {
	var response []*graphdbFulton.EdgeGetResponse
	err := hystrix.Do(clients.HystrixGraphDBGetBatchFollows, func() (err error) {
		defer func() {
			if p := recover(); p != nil {
				err = fmt.Errorf("%s circuit panic=%v", clients.HystrixGraphDBGetBatchFollows, p)
			}
		}()

		edges := make([]*graphdbFulton.EdgeGetResponse, 0, len(targetUserIDs))
		for _, targetUserID := range targetUserIDs {
			resp, err := b.GraphDBFultonClient.EdgeGet(ctx, &graphdbFulton.EdgeGetRequest{
				Edge: &graphdbFulton.Edge{
					From: &graphdbFulton.Node{
						Type: UserKind,
						Id:   fromUserID,
					},
					To: &graphdbFulton.Node{
						Type: UserKind,
						Id:   targetUserID,
					},
					Type: FollowsKind,
				},
			})
			if err != nil {
				return err
			}
			if resp != nil {
				edges = append(edges, resp)
			}
		}
		response = edges
		return nil
	}, nil)
	return response, err
}
