package backend_test

import (
	"errors"
	"testing"

	graphdbFulton "code.justin.tv/amzn/TwitchVXGraphDBECSTwirp"
	"code.justin.tv/feeds/following-service/backend"
	"code.justin.tv/feeds/following-service/mocks"
	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/suite"
)

type GetBatchFollowsSuite struct {
	suite.Suite
	backend backend.Backender
}

func (suite *GetBatchFollowsSuite) SetupTest() {
	client := &mocks.TwitchVXGraphDBECS{}
	client.On("EdgeGet", mock.Anything, &graphdbFulton.EdgeGetRequest{
		Edge: &graphdbFulton.Edge{
			From: &graphdbFulton.Node{
				Type: backend.UserKind,
				Id:   "1",
			},
			To: &graphdbFulton.Node{
				Type: backend.UserKind,
				Id:   "2",
			},
			Type: backend.FollowsKind,
		},
	}).Return(&graphdbFulton.EdgeGetResponse{
		Edge: &graphdbFulton.LoadedEdge{
			Edge: &graphdbFulton.Edge{
				From: &graphdbFulton.Node{
					Type: backend.UserKind,
					Id:   "1",
				},
				To: &graphdbFulton.Node{
					Type: backend.UserKind,
					Id:   "2",
				},
				Type: backend.FollowsKind,
			},
		},
	}, nil)
	client.On("EdgeGet", mock.Anything, &graphdbFulton.EdgeGetRequest{
		Edge: &graphdbFulton.Edge{
			From: &graphdbFulton.Node{
				Type: backend.UserKind,
				Id:   "1",
			},
			To: &graphdbFulton.Node{
				Type: backend.UserKind,
				Id:   "3",
			},
			Type: backend.FollowsKind,
		},
	}).Return(&graphdbFulton.EdgeGetResponse{
		Edge: &graphdbFulton.LoadedEdge{
			Edge: &graphdbFulton.Edge{
				From: &graphdbFulton.Node{
					Type: backend.UserKind,
					Id:   "1",
				},
				To: &graphdbFulton.Node{
					Type: backend.UserKind,
					Id:   "3",
				},
				Type: backend.FollowsKind,
			},
		},
	}, nil)
	client.On("EdgeGet", mock.Anything, &graphdbFulton.EdgeGetRequest{
		Edge: &graphdbFulton.Edge{
			From: &graphdbFulton.Node{
				Type: backend.UserKind,
				Id:   "1",
			},
			To: &graphdbFulton.Node{
				Type: backend.UserKind,
				Id:   "4",
			},
			Type: backend.FollowsKind,
		},
	}).Return(nil, errors.New("Not Found"))
	client.On("EdgeGet", mock.Anything, &graphdbFulton.EdgeGetRequest{
		Edge: &graphdbFulton.Edge{
			From: &graphdbFulton.Node{
				Type: backend.UserKind,
				Id:   "1",
			},
			To: &graphdbFulton.Node{
				Type: backend.UserKind,
				Id:   "5",
			},
			Type: backend.FollowsKind,
		},
	}).Return(nil, nil).Run(func(arg mock.Arguments) { panic("panic") })
	suite.backend = backend.Backend{
		GraphDBFultonClient: client,
		ErrorLogger:         NewNoopErrorLogger(),
	}
}

func (suite *GetBatchFollowsSuite) TestSuccessfulRequest() {
	follows, err := suite.backend.GetBatchFollows(nil, "1", []string{"2", "3"})
	suite.Nil(err)
	suite.NotNil(follows)
}

func (suite *GetBatchFollowsSuite) TestFailedRequest() {
	follows, err := suite.backend.GetBatchFollows(nil, "1", []string{"4"})
	suite.EqualError(err, "Not Found")
	suite.Nil(follows)
}

func (suite *GetBatchFollowsSuite) TestPanic() {
	follows, err := suite.backend.GetBatchFollows(nil, "1", []string{"5"})
	suite.EqualError(err, "graphdb_getbatchfollows circuit panic=panic")
	suite.Nil(follows)
}

func TestGetBatchFollowsSuite(t *testing.T) {
	suite.Run(t, new(GetBatchFollowsSuite))
}
