package backend

import (
	"context"
	"fmt"

	graphdbFulton "code.justin.tv/amzn/TwitchVXGraphDBECSTwirp"
	"code.justin.tv/feeds/following-service/clients"
	"github.com/afex/hystrix-go/hystrix"
)

func (b Backend) GetFollow(ctx context.Context, fromUserID string, targetUserID string) (*graphdbFulton.EdgeGetResponse, error) {
	var response *graphdbFulton.EdgeGetResponse
	err := hystrix.Do(clients.HystrixGraphDBGetFollow, func() (err error) {
		defer func() {
			if p := recover(); p != nil {
				err = fmt.Errorf("%s circuit panic=%v", clients.HystrixGraphDBGetFollow, p)
			}
		}()

		resp, err := b.GraphDBFultonClient.EdgeGet(ctx, &graphdbFulton.EdgeGetRequest{
			Edge: &graphdbFulton.Edge{
				From: &graphdbFulton.Node{
					Type: UserKind,
					Id:   fromUserID,
				},
				To: &graphdbFulton.Node{
					Type: UserKind,
					Id:   targetUserID,
				},
				Type: FollowsKind,
			},
		})
		if err != nil {
			return err
		}

		response = resp
		return nil
	}, nil)
	return response, err
}
