package backend_test

import (
	"errors"
	"testing"

	graphdbFulton "code.justin.tv/amzn/TwitchVXGraphDBECSTwirp"
	"code.justin.tv/feeds/following-service/backend"
	"code.justin.tv/feeds/following-service/mocks"
	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/suite"
)

type GetFollowSuite struct {
	suite.Suite
	backend backend.Backender
}

func (suite *GetFollowSuite) SetupTest() {
	client := &mocks.TwitchVXGraphDBECS{}
	client.On("EdgeGet", mock.Anything, &graphdbFulton.EdgeGetRequest{
		Edge: &graphdbFulton.Edge{
			From: &graphdbFulton.Node{
				Type: backend.UserKind,
				Id:   "1",
			},
			To: &graphdbFulton.Node{
				Type: backend.UserKind,
				Id:   "2",
			},
			Type: backend.FollowsKind,
		},
	}).Return(&graphdbFulton.EdgeGetResponse{
		Edge: &graphdbFulton.LoadedEdge{
			Edge: &graphdbFulton.Edge{
				From: &graphdbFulton.Node{
					Type: backend.UserKind,
					Id:   "1",
				},
				To: &graphdbFulton.Node{
					Type: backend.UserKind,
					Id:   "2",
				},
				Type: backend.FollowsKind,
			},
		},
	}, nil)
	client.On("EdgeGet", mock.Anything, &graphdbFulton.EdgeGetRequest{
		Edge: &graphdbFulton.Edge{
			From: &graphdbFulton.Node{
				Type: backend.UserKind,
				Id:   "1",
			},
			To: &graphdbFulton.Node{
				Type: backend.UserKind,
				Id:   "3",
			},
			Type: backend.FollowsKind,
		},
	}).Return(nil, errors.New("Not Found"))
	client.On("EdgeGet", mock.Anything, &graphdbFulton.EdgeGetRequest{
		Edge: &graphdbFulton.Edge{
			From: &graphdbFulton.Node{
				Type: backend.UserKind,
				Id:   "1",
			},
			To: &graphdbFulton.Node{
				Type: backend.UserKind,
				Id:   "4",
			},
			Type: backend.FollowsKind,
		},
	}).Return(nil, nil).Run(func(arg mock.Arguments) { panic("panic") })
	suite.backend = backend.Backend{
		GraphDBFultonClient: client,
		ErrorLogger:         NewNoopErrorLogger(),
	}
}

func (suite *GetFollowSuite) TestSuccessfulRequest() {
	follow, err := suite.backend.GetFollow(nil, "1", "2")
	suite.Nil(err)
	suite.NotNil(follow)
}

func (suite *GetFollowSuite) TestFailedRequest() {
	follow, err := suite.backend.GetFollow(nil, "1", "3")
	suite.EqualError(err, "Not Found")
	suite.Nil(follow)
}

func (suite *GetFollowSuite) TestPanic() {
	follow, err := suite.backend.GetFollow(nil, "1", "4")
	suite.EqualError(err, "graphdb_getfollow circuit panic=panic")
	suite.Nil(follow)
}

func TestGetFollowSuite(t *testing.T) {
	suite.Run(t, new(GetFollowSuite))
}
