package backend

import (
	"context"
	"fmt"
	"sync"

	graphdbFulton "code.justin.tv/amzn/TwitchVXGraphDBECSTwirp"
	"code.justin.tv/feeds/following-service/clients"
	"github.com/afex/hystrix-go/hystrix"
)

// HideAllFollows hide all of userID's follows and followers
func (b Backend) HideAllFollows(ctx context.Context, userID string) error {
	var followsErr error
	var followersErr error
	var wg sync.WaitGroup
	wg.Add(2)
	go func() {
		defer wg.Done()
		followsErr = hystrix.Do(clients.HystrixGraphDBHideAllFollows, func() (err error) {
			defer func() {
				if p := recover(); p != nil {
					err = fmt.Errorf("%s circuit panic=%v", clients.HystrixGraphDBHideAllFollows, p)
				}
			}()

			var gdbErr error
			_, gdbErr = b.GraphDBFultonClient.BulkEdgeUpdate(ctx, &graphdbFulton.BulkEdgeUpdateRequest{
				From: &graphdbFulton.Node{
					Type: UserKind,
					Id:   userID,
				},
				EdgeType:    FollowsKind,
				NewEdgeType: HiddenFollowsKind,
			})
			if gdbErr != nil {
				return gdbErr
			}

			return nil
		}, nil)
	}()
	go func() {
		defer wg.Done()
		followersErr = hystrix.Do(clients.HystrixGraphDBHideAllFollowers, func() (err error) {
			defer func() {
				if p := recover(); p != nil {
					err = fmt.Errorf("%s circuit panic=%v", clients.HystrixGraphDBHideAllFollowers, p)
				}
			}()

			var gdbErr error
			_, gdbErr = b.GraphDBFultonClient.BulkEdgeUpdate(ctx, &graphdbFulton.BulkEdgeUpdateRequest{
				From: &graphdbFulton.Node{
					Type: UserKind,
					Id:   userID,
				},
				EdgeType:    FollowersKind,
				NewEdgeType: HiddenFollowersKind,
			})
			if gdbErr != nil {
				return gdbErr
			}

			return nil
		}, nil)
	}()
	wg.Wait()
	if followsErr != nil {
		return followsErr
	}
	return followersErr
}
