package backend_test

import (
	"errors"
	"testing"

	graphdbFulton "code.justin.tv/amzn/TwitchVXGraphDBECSTwirp"
	"code.justin.tv/feeds/following-service/backend"
	"code.justin.tv/feeds/following-service/mocks"
	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/suite"
)

type HideAllFollowsSuite struct {
	suite.Suite
	backend backend.Backender
}

func (suite *HideAllFollowsSuite) SetupTest() {
	client := &mocks.TwitchVXGraphDBECS{}
	suite.backend = backend.Backend{
		GraphDBFultonClient: client,
		ErrorLogger:         NewNoopErrorLogger(),
	}
	client.On("BulkEdgeUpdate", mock.Anything, &graphdbFulton.BulkEdgeUpdateRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "1",
		},
		EdgeType:    backend.FollowsKind,
		NewEdgeType: backend.HiddenFollowsKind,
	}).Return(nil, nil)
	client.On("BulkEdgeUpdate", mock.Anything, &graphdbFulton.BulkEdgeUpdateRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "1",
		},
		EdgeType:    backend.FollowersKind,
		NewEdgeType: backend.HiddenFollowersKind,
	}).Return(nil, nil)
	client.On("BulkEdgeUpdate", mock.Anything, &graphdbFulton.BulkEdgeUpdateRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "2",
		},
		EdgeType:    backend.FollowsKind,
		NewEdgeType: backend.HiddenFollowsKind,
	}).Return(nil, nil)
	client.On("BulkEdgeUpdate", mock.Anything, &graphdbFulton.BulkEdgeUpdateRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "2",
		},
		EdgeType:    backend.FollowersKind,
		NewEdgeType: backend.HiddenFollowersKind,
	}).Return(nil, errors.New("broken"))
	client.On("BulkEdgeUpdate", mock.Anything, &graphdbFulton.BulkEdgeUpdateRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "3",
		},
		EdgeType:    backend.FollowsKind,
		NewEdgeType: backend.HiddenFollowsKind,
	}).Return(nil, nil).Run(func(args mock.Arguments) { panic("panic") })
	client.On("BulkEdgeUpdate", mock.Anything, &graphdbFulton.BulkEdgeUpdateRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "3",
		},
		EdgeType:    backend.FollowersKind,
		NewEdgeType: backend.HiddenFollowersKind,
	}).Return(nil, nil)
}

func (suite *HideAllFollowsSuite) TestSuccessfulRequest() {
	err := suite.backend.HideAllFollows(nil, "1")
	suite.Nil(err)
}

func (suite *HideAllFollowsSuite) TestFailedRequest() {
	err := suite.backend.HideAllFollows(nil, "2")
	suite.NotNil(err)
	suite.EqualError(err, "broken")
}

func (suite *HideAllFollowsSuite) TestPanic() {
	err := suite.backend.HideAllFollows(nil, "3")
	suite.NotNil(err)
	suite.EqualError(err, "graphdb_hide_all_follows circuit panic=panic")
}

func TestHideAllFollowsSuite(t *testing.T) {
	suite.Run(t, new(HideAllFollowsSuite))
}
