package backend

import (
	"context"
	"fmt"

	graphdbFulton "code.justin.tv/amzn/TwitchVXGraphDBECSTwirp"
	"code.justin.tv/feeds/following-service/clients"
	"github.com/afex/hystrix-go/hystrix"
)

func (b Backend) ListFollowers(ctx context.Context, userID string, cursor string, limit int, offset int, direction string) (*graphdbFulton.EdgeListResponse, error) {
	var response *graphdbFulton.EdgeListResponse
	err := hystrix.Do(clients.HystrixGraphDBListFollowers, func() (err error) {
		defer func() {
			if p := recover(); p != nil {
				err = fmt.Errorf("%s circuit panic=%v", clients.HystrixGraphDBListFollowers, p)
			}
		}()

		order := graphdbFulton.PagedRequest_ASC
		if direction == "desc" {
			order = graphdbFulton.PagedRequest_DESC
		}

		response, err = b.GraphDBFultonClient.EdgeList(ctx, &graphdbFulton.EdgeListRequest{
			From: &graphdbFulton.Node{
				Type: UserKind,
				Id:   userID,
			},
			EdgeType: FollowersKind,
			Page: &graphdbFulton.PagedRequest{
				Cursor: cursor,
				Limit:  int64(limit),
				Order:  order,
			},
		})
		return err
	}, nil)
	return response, err
}
