package backend_test

import (
	"errors"
	"testing"

	graphdbFulton "code.justin.tv/amzn/TwitchVXGraphDBECSTwirp"
	"code.justin.tv/feeds/following-service/backend"
	"code.justin.tv/feeds/following-service/mocks"
	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/suite"
)

type ListFollowersSuite struct {
	suite.Suite
	backend backend.Backender
}

func (suite *ListFollowersSuite) SetupTest() {
	client := &mocks.TwitchVXGraphDBECS{}
	client.On("EdgeList", mock.Anything, &graphdbFulton.EdgeListRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "1",
		},
		EdgeType: backend.FollowersKind,
		Page: &graphdbFulton.PagedRequest{
			Limit: 20,
			Order: graphdbFulton.PagedRequest_ASC,
		},
	}).Return(&graphdbFulton.EdgeListResponse{}, nil)
	client.On("EdgeList", mock.Anything, &graphdbFulton.EdgeListRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "2",
		},
		EdgeType: backend.FollowersKind,
		Page: &graphdbFulton.PagedRequest{
			Limit: 20,
			Order: graphdbFulton.PagedRequest_ASC,
		},
	}).Return(nil, errors.New("ErrorError"))
	client.On("EdgeList", mock.Anything, &graphdbFulton.EdgeListRequest{
		From: &graphdbFulton.Node{
			Type: backend.UserKind,
			Id:   "3",
		},
		EdgeType: backend.FollowersKind,
		Page: &graphdbFulton.PagedRequest{
			Limit: 20,
			Order: graphdbFulton.PagedRequest_ASC,
		},
	}).Return(nil, nil).Run(func(arg mock.Arguments) { panic("panic") })
	suite.backend = backend.Backend{
		GraphDBFultonClient: client,
		ErrorLogger:         NewNoopErrorLogger(),
	}
}

func (suite *ListFollowersSuite) TestSuccessfulRequest() {
	followers, err := suite.backend.ListFollowers(nil, "1", "", 20, 0, "asc")
	suite.Nil(err)
	suite.NotNil(followers)
}

func (suite *ListFollowersSuite) TestFailedRequest() {
	followers, err := suite.backend.ListFollowers(nil, "2", "", 20, 0, "asc")
	suite.EqualError(err, "ErrorError")
	suite.Nil(followers)
}

func (suite *ListFollowersSuite) TestPanic() {
	followers, err := suite.backend.ListFollowers(nil, "3", "", 20, 0, "asc")
	suite.EqualError(err, "graphdb_listfollowers circuit panic=panic")
	suite.Nil(followers)
}

func TestListFollowersSuite(t *testing.T) {
	suite.Run(t, new(ListFollowersSuite))
}
