package backend

import (
	"context"
	"fmt"
	"sync"

	graphdbFulton "code.justin.tv/amzn/TwitchVXGraphDBECSTwirp"
	"code.justin.tv/feeds/following-service/clients"
	"github.com/afex/hystrix-go/hystrix"
)

// RestoreAllFollows restore all of userID's follows and followers
func (b Backend) RestoreAllFollows(ctx context.Context, userID string) error {
	var followsErr error
	var followersErr error
	var wg sync.WaitGroup
	wg.Add(2)
	go func() {
		defer wg.Done()
		followsErr = hystrix.Do(clients.HystrixGraphDBRestoreAllFollows, func() (err error) {
			defer func() {
				if p := recover(); p != nil {
					err = fmt.Errorf("%s circuit panic=%v", clients.HystrixGraphDBRestoreAllFollows, p)
				}
			}()

			var gdbErr error
			_, gdbErr = b.GraphDBFultonClient.BulkEdgeUpdate(ctx, &graphdbFulton.BulkEdgeUpdateRequest{
				From: &graphdbFulton.Node{
					Type: UserKind,
					Id:   userID,
				},
				EdgeType:    HiddenFollowsKind,
				NewEdgeType: FollowsKind,
			})
			if gdbErr != nil {
				return gdbErr
			}

			return nil
		}, nil)
	}()
	go func() {
		defer wg.Done()
		followersErr = hystrix.Do(clients.HystrixGraphDBRestoreAllFollowers, func() (err error) {
			defer func() {
				if p := recover(); p != nil {
					err = fmt.Errorf("%s circuit panic=%v", clients.HystrixGraphDBRestoreAllFollowers, p)
				}
			}()

			var gdbErr error
			_, gdbErr = b.GraphDBFultonClient.BulkEdgeUpdate(ctx, &graphdbFulton.BulkEdgeUpdateRequest{
				From: &graphdbFulton.Node{
					Type: UserKind,
					Id:   userID,
				},
				EdgeType:    HiddenFollowersKind,
				NewEdgeType: FollowersKind,
			})
			if gdbErr != nil {
				return gdbErr
			}

			return nil
		}, nil)
	}()
	wg.Wait()
	if followsErr != nil {
		return followsErr
	}
	return followersErr
}
